/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.oauth.ClientSettingsPaths;
import com.pingidentity.admin.api.model.oauth.ClientSettings;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.List;
import java.util.Set;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class OAuthDynamicClientRegistrationAuthorizationDetailTypesConstraintsValidator
extends AbstractValidator {
    private ClientSettings clientSettings;

    public OAuthDynamicClientRegistrationAuthorizationDetailTypesConstraintsValidator(ClientSettings clientSettings) {
        this.clientSettings = clientSettings;
    }

    public boolean validate() {
        Set validAuthorizationDetails = MgmtFactory.getAuthorizationDetailTypesManager().getTypes();
        List<String> authorizationDetailTypes = this.clientSettings.getDynamicClientRegistration().getAllowedAuthorizationDetailTypes();
        if (authorizationDetailTypes != null) {
            int index = 0;
            for (String authorizationDetailType : authorizationDetailTypes) {
                if (!validAuthorizationDetails.contains(authorizationDetailType)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_client_setting_allowed_authorization_detail_types_invalid, ClientSettingsPaths.getAllowedAuthorizationDetailTypes(index)));
                }
                ++index;
            }
        }
        return !this.hasErrors();
    }
}

