/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.oauth.ClientSettingsPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.domain.ScopeUtil;

public class OAuthDynamicClientRegistrationValidator
extends AbstractValidator {
    private boolean enableDynamicClientRegistration;
    private boolean requireInitialAccessToken;
    private String initialAccessTokenScope;

    public OAuthDynamicClientRegistrationValidator(boolean enableDynamicClientRegistration, boolean requireInitialAccessToken, String initialAccessTokenScope) {
        this.enableDynamicClientRegistration = enableDynamicClientRegistration;
        this.requireInitialAccessToken = requireInitialAccessToken;
        this.initialAccessTokenScope = initialAccessTokenScope;
    }

    public boolean validate() {
        if (this.enableDynamicClientRegistration && this.requireInitialAccessToken && (StringUtils.isBlank((String)this.initialAccessTokenScope) || !this.containsInitialAccessToken(this.initialAccessTokenScope))) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_client_setting_initial_access_token, ClientSettingsPaths.getInitialAccessToken()));
        }
        return !this.hasErrors();
    }

    private boolean containsInitialAccessToken(String initialAccessTokenScope) {
        HashSet scopes = new HashSet();
        scopes.addAll(ScopeUtil.getAllCommonScopeDescriptions().keySet());
        scopes.addAll(ScopeUtil.getCommonScopeGroupDescriptions().keySet());
        scopes.addAll(ScopeUtil.getAllExclusiveScopeDescriptions().keySet());
        scopes.addAll(ScopeUtil.getExclusiveScopeGroupDescriptions().keySet());
        return scopes.contains(initialAccessTokenScope);
    }
}

