/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.model.fieldpaths.oauth.IdpAdapterMappingPaths;
import com.pingidentity.admin.api.model.oauth.IdpAdapterMapping;
import com.pingidentity.admin.api.model.oauth.SourceToUserKeyMapping;
import com.pingidentity.admin.api.validator.AttributeSetSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.OAuthSourceToUserKeyValidator;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.Map;
import java.util.Set;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.mgmt.IdpAdapterManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class OAuthIdpAdapterMappingValidator
extends OAuthSourceToUserKeyValidator {
    private static final IdpAdapterManager IDP_ADAPTER_MGR = MgmtFactory.getIdpAdapterManager();
    private IdpAuthnAdapterInstance instance;
    private SourceToUserKeyMapping mapping;

    public OAuthIdpAdapterMappingValidator(IdpAdapterMapping mapping, ValidatorContext context) {
        super(mapping, context);
    }

    @Override
    protected void init(SourceToUserKeyMapping mapping) {
        this.instance = (IdpAuthnAdapterInstance)IDP_ADAPTER_MGR.getInstance(mapping.getId());
        this.mapping = mapping;
    }

    @Override
    public boolean validate() {
        if (this.instance == null || !this.instance.getId().equals(this.mapping.getId())) {
            this.appendError(ApiMessageKey.idp_adapter_not_found, IdpAdapterMappingPaths.getId(), this.mapping.getId());
            return false;
        }
        super.validate();
        return !this.hasErrors();
    }

    private AttributeSetSourceTypeValidatorBuilder createAdapterTypeBuilder() {
        if (this.instance == null) {
            return null;
        }
        Set srcNames = this.instance.getAttributeContract().getAllAttributeNames();
        return new AttributeSetSourceTypeValidatorBuilder(srcNames, SourceType.ADAPTER);
    }

    private void appendError(ApiMessageKey errorId, String fieldPath, Object ... params) {
        this.appendError(ValidationErrorFactory.getInstance().create(errorId, fieldPath, params));
    }

    @Override
    protected Set<String> getSourceCoreSubstitutionVariables() {
        if (this.instance == null) {
            return null;
        }
        return this.instance.getAttributeContract().getAllAttributeNames();
    }

    @Override
    protected void addAdditionalSourceValidators(Map<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources) {
        AttributeSetSourceTypeValidatorBuilder builder = this.createAdapterTypeBuilder();
        if (builder != null) {
            validSources.put(new SourceTypeIdKey(SourceType.ADAPTER), builder);
        }
    }

    @Override
    protected String getSourceName() {
        return "adapter";
    }
}

