/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.model.fieldpaths.OAuthOidcKeysPaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.admin.api.validator.simple.X509CountryValidator;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.error.ValidationErrorFactory;

public class OAuthOidcDynamicKeysValidator
extends CompositeValidator {
    private OAuthOidcDynamicKeysValidator() {
    }

    public static class Builder {
        private final ValidationErrorFactory validationErrorFactory;
        private final boolean publishCertificates;
        private String certOrgName;
        private String certCountry;

        public Builder(ValidationErrorFactory validationErrorFactory, boolean publishCertificates) {
            this.validationErrorFactory = validationErrorFactory;
            this.publishCertificates = publishCertificates;
        }

        public Builder certOrgName(String certOrgName) {
            this.certOrgName = certOrgName;
            return this;
        }

        public Builder certCountry(String certCountry) {
            this.certCountry = certCountry;
            return this;
        }

        public OAuthOidcDynamicKeysValidator build() {
            OAuthOidcDynamicKeysValidator validator = new OAuthOidcDynamicKeysValidator();
            String countryPath = OAuthOidcKeysPaths.OAuthOidcKeysSettingsCertificatePaths.getCountryPath();
            validator.addValidator((Validator)new X509CountryValidator(this.validationErrorFactory, this.certCountry, "Country", countryPath, this.publishCertificates));
            if (this.publishCertificates) {
                String organizationPath = OAuthOidcKeysPaths.OAuthOidcKeysSettingsCertificatePaths.getOrganizationPath();
                validator.addValidator((Validator)new NotBlankValidator(this.certOrgName, "Organization", organizationPath));
            }
            return validator;
        }
    }
}

