/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.RsaAlgKeyId;
import com.pingidentity.admin.api.model.fieldpaths.OAuthOidcKeysPaths;
import com.pingidentity.admin.api.validator.OAuthOidcKeysValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.crypto.jwk.JwkFacilitator;
import com.pingidentity.pf.admin.rest.translator.OAuthOidcKeysTranslator;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sourceid.jose.jwk.AccessTokenMgmtJwkPublishUtil;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;

public class OAuthOidcKeysBaseValidator
extends AbstractValidator {
    public static final String P_256_EC = "EC with P-256 curve";
    public static final String P_384_EC = "EC with P-384 curve";
    public static final String P_521_EC = "EC with P-521 curve";
    private static final int KEY_ID_MAX_LENGTH = 100;
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private final boolean staticJwksEnabled;
    private final OAuthOidcKeysValidator.StaticKeyType type;
    private final String p256ActiveCertId;
    private final String p256PreviousCertId;
    private final boolean p256PublishX5cParameter;
    private final String p256ActiveKeyId;
    private final String p256PreviousKeyId;
    private final String p384ActiveCertId;
    private final String p384PreviousCertId;
    private final boolean p384PublishX5cParameter;
    private final String p384ActiveKeyId;
    private final String p384PreviousKeyId;
    private final String p521ActiveCertId;
    private final String p521PreviousCertId;
    private final boolean p521PublishX5cParameter;
    private final String p521ActiveKeyId;
    private final String p521PreviousKeyId;
    private final String rsaActiveCertId;
    private final String rsaPreviousCertId;
    private final boolean rsaPublishX5cParameter;
    private final String rsaActiveKeyId;
    private final String rsaPreviousKeyId;
    private final boolean skipRsaValidation;
    private final boolean keysRequiredByJwtAtm;
    private final BearerAccessTokenMgmtPluginManager bearerAccessTokenMgmtPluginManager;
    private final boolean isAdditionalKeyset;
    private final List<RsaAlgKeyId> rsaAlgTypesActiveCustomKeyIds;
    private final List<RsaAlgKeyId> rsaAlgTypesPreviousCustomKeyIds;

    public OAuthOidcKeysBaseValidator(Builder builder) {
        this.type = builder.type;
        this.staticJwksEnabled = builder.staticJwksEnabled;
        this.p256ActiveCertId = builder.p256ActiveCertId;
        this.p256PreviousCertId = builder.p256PreviousCertId;
        this.p256PublishX5cParameter = builder.p256PublishX5cParameter;
        this.p256ActiveKeyId = builder.p256ActiveKeyId;
        this.p256PreviousKeyId = builder.p256PreviousKeyId;
        this.p384ActiveCertId = builder.p384ActiveCertId;
        this.p384PreviousCertId = builder.p384PreviousCertId;
        this.p384PublishX5cParameter = builder.p384PublishX5cParameter;
        this.p384ActiveKeyId = builder.p384ActiveKeyId;
        this.p384PreviousKeyId = builder.p384PreviousKeyId;
        this.p521ActiveCertId = builder.p521ActiveCertId;
        this.p521PreviousCertId = builder.p521PreviousCertId;
        this.p521PublishX5cParameter = builder.p521PublishX5cParameter;
        this.p521ActiveKeyId = builder.p521ActiveKeyId;
        this.p521PreviousKeyId = builder.p521PreviousKeyId;
        this.rsaActiveCertId = builder.rsaActiveCertId;
        this.rsaPreviousCertId = builder.rsaPreviousCertId;
        this.rsaPublishX5cParameter = builder.rsaPublishX5cParameter;
        this.rsaActiveKeyId = builder.rsaActiveKeyId;
        this.rsaPreviousKeyId = builder.rsaPreviousKeyId;
        this.skipRsaValidation = builder.setSkipRsaValidation;
        this.keysRequiredByJwtAtm = builder.keysRequiredByJwtAtm;
        this.bearerAccessTokenMgmtPluginManager = builder.bearerAccessTokenMgmtPluginManager;
        this.isAdditionalKeyset = builder.isAdditionalKeyset;
        this.rsaAlgTypesActiveCustomKeyIds = builder.rsaAlgTypesActiveCustomKeyIds;
        this.rsaAlgTypesPreviousCustomKeyIds = builder.rsaAlgTypesPreviousCustomKeyIds;
    }

    private void validateKeyIds() {
        HashSet<String> keyIds = new HashSet<String>();
        this.validateRsaAlgTypeKeyIdMap(this.rsaAlgTypesActiveCustomKeyIds, keyIds, this.rsaActiveCertId, OAuthOidcKeysPaths.getRsaAlgorithmActiveKeyIdsPath());
        this.validateRsaAlgTypeKeyIdMap(this.rsaAlgTypesPreviousCustomKeyIds, keyIds, this.rsaPreviousCertId, OAuthOidcKeysPaths.getRsaAlgorithmPreviousKeyIdsPath());
        this.validateKeyId(keyIds, this.p256ActiveCertId, this.p256ActiveKeyId, this.type == OAuthOidcKeysValidator.StaticKeyType.DECRYPTION ? OAuthOidcKeysPaths.getP256DecryptionActiveKeyIdPath() : OAuthOidcKeysPaths.getP256ActiveKeyIdPath());
        this.validateKeyId(keyIds, this.p256PreviousCertId, this.p256PreviousKeyId, this.type == OAuthOidcKeysValidator.StaticKeyType.DECRYPTION ? OAuthOidcKeysPaths.getP256DecryptionPreviousKeyIdPath() : OAuthOidcKeysPaths.getP256PreviousKeyIdPath());
        this.validateKeyId(keyIds, this.p384ActiveCertId, this.p384ActiveKeyId, this.type == OAuthOidcKeysValidator.StaticKeyType.DECRYPTION ? OAuthOidcKeysPaths.getP384DecryptionActiveKeyIdPath() : OAuthOidcKeysPaths.getP384ActiveKeyIdPath());
        this.validateKeyId(keyIds, this.p384PreviousCertId, this.p384PreviousKeyId, this.type == OAuthOidcKeysValidator.StaticKeyType.DECRYPTION ? OAuthOidcKeysPaths.getP384DecryptionPreviousKeyIdPath() : OAuthOidcKeysPaths.getP384PreviousKeyIdPath());
        this.validateKeyId(keyIds, this.p521ActiveCertId, this.p521ActiveKeyId, this.type == OAuthOidcKeysValidator.StaticKeyType.DECRYPTION ? OAuthOidcKeysPaths.getP521DecryptionActiveKeyIdPath() : OAuthOidcKeysPaths.getP521ActiveKeyIdPath());
        this.validateKeyId(keyIds, this.p521PreviousCertId, this.p521PreviousKeyId, this.type == OAuthOidcKeysValidator.StaticKeyType.DECRYPTION ? OAuthOidcKeysPaths.getP521DecryptionPreviousKeyIdPath() : OAuthOidcKeysPaths.getP521PreviousKeyIdPath());
        this.validateKeyId(keyIds, this.rsaActiveCertId, this.rsaActiveKeyId, this.type == OAuthOidcKeysValidator.StaticKeyType.DECRYPTION ? OAuthOidcKeysPaths.getRsaDecryptionActiveKeyIdPath() : OAuthOidcKeysPaths.getRsaActiveKeyIdPath());
        this.validateKeyId(keyIds, this.rsaPreviousCertId, this.rsaPreviousKeyId, this.type == OAuthOidcKeysValidator.StaticKeyType.DECRYPTION ? OAuthOidcKeysPaths.getRsaDecryptionPreviousKeyIdPath() : OAuthOidcKeysPaths.getRsaPreviousKeyIdPath());
        this.validateGeneratedRsa256KeyId(keyIds, this.rsaActiveKeyId, this.rsaAlgTypesActiveCustomKeyIds, OAuthOidcKeysPaths.getRsaActiveKeyIdPath());
        this.validateGeneratedRsa256KeyId(keyIds, this.rsaPreviousKeyId, this.rsaAlgTypesPreviousCustomKeyIds, OAuthOidcKeysPaths.getRsaPreviousKeyIdPath());
    }

    private void validateGeneratedRsa256KeyId(Set<String> keyIds, String keyId, List<RsaAlgKeyId> rsaAlgKeyTypes, String path) {
        if (StringUtils.isNotEmpty((String)keyId) && this.type == OAuthOidcKeysValidator.StaticKeyType.SIGNING && (rsaAlgKeyTypes == null || rsaAlgKeyTypes.isEmpty() || rsaAlgKeyTypes.stream().noneMatch(rsaAlgKeyType -> "RS256".equals(rsaAlgKeyType.getRsaAlgType())))) {
            this.validateKeyId(keyIds, keyId, keyId + "_RS256", path);
        }
    }

    private void validateRsaAlgTypeKeyIdMap(List<RsaAlgKeyId> rsaAlgTypeKeyIds, Set<String> keyIds, String certId, String path) {
        if (rsaAlgTypeKeyIds != null) {
            HashSet<String> algTypes = new HashSet<String>();
            int index = 0;
            for (RsaAlgKeyId rsaEntry : rsaAlgTypeKeyIds) {
                String rsaAlgType = rsaEntry.getRsaAlgType();
                String keyId = rsaEntry.getKeyId();
                if (StringUtils.isBlank((String)rsaAlgType)) {
                    this.appendError(this.errorFactory.create(ApiMessageKey.field_required, OAuthOidcKeysPaths.getRsaAlgTypePath(path, index), new Object[]{"RSA signing algorithm type"}));
                } else if (!JwkFacilitator.SUPPORTED_RSA_ALG.contains(rsaEntry.getRsaAlgType())) {
                    this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_rsa_alg_type_key_id_map_invalid_alg, path, new Object[]{rsaAlgType}));
                } else if (algTypes.contains(rsaAlgType)) {
                    this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_duplicate_rsa_alg, path, new Object[]{rsaAlgType}));
                }
                if (StringUtils.isBlank((String)keyId)) {
                    this.appendError(this.errorFactory.create(ApiMessageKey.field_required, OAuthOidcKeysPaths.getKeyIdPath(path, index), new Object[]{"Key ID"}));
                }
                this.validateKeyId(keyIds, certId, keyId, path);
                algTypes.add(rsaAlgType);
                ++index;
            }
        }
    }

    private void validateKeyId(Set<String> keyIds, String certId, String keyId, String path) {
        if (!StringUtils.isEmpty((String)keyId)) {
            if (keyId.length() > 100) {
                this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_key_id_invalid_length, path, new Object[]{keyId, 100}));
            }
            if (StringUtils.isEmpty((String)certId)) {
                this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_key_id_without_certificate, path, new Object[]{keyId}));
            }
            if (keyIds.contains(keyId)) {
                ApiMessageKey errorMessageId = ApiMessageKey.oauthoidckeys_duplicate_key_id_signing;
                if (this.type == OAuthOidcKeysValidator.StaticKeyType.DECRYPTION) {
                    errorMessageId = ApiMessageKey.oauthoidckeys_duplicate_key_id_decryption;
                }
                this.appendError(this.errorFactory.create(errorMessageId, path, new Object[]{keyId, this.type}));
            } else {
                String atmInstanceId = AccessTokenMgmtJwkPublishUtil.getAtmInstanceIdForKeyId((String)keyId, null);
                if (atmInstanceId == null) {
                    keyIds.add(keyId);
                } else {
                    this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_key_id_must_be_unique, path, new Object[]{keyId, atmInstanceId}));
                }
            }
        }
    }

    protected boolean isAnyEmptyActiveCert() {
        if (!this.skipRsaValidation && this.rsaActiveCertId == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_active_certs_required, OAuthOidcKeysPaths.getRsaActiveCertPath(), new Object[]{this.type, "RSA"}));
            return true;
        }
        return false;
    }

    private void checkAnyActivePreviousCertsSame() {
        String path;
        if (this.p256ActiveCertId != null && this.p256ActiveCertId.equals(this.p256PreviousCertId)) {
            path = this.type == OAuthOidcKeysValidator.StaticKeyType.SIGNING ? OAuthOidcKeysPaths.getP256PreviousCertPath() : OAuthOidcKeysPaths.getP256DecryptionPreviousCertPath();
            this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_active_previous_same, path, new Object[]{this.type, P_256_EC}));
        }
        if (this.p384ActiveCertId != null && this.p384ActiveCertId.equals(this.p384PreviousCertId)) {
            path = this.type == OAuthOidcKeysValidator.StaticKeyType.SIGNING ? OAuthOidcKeysPaths.getP384PreviousCertPath() : OAuthOidcKeysPaths.getP384DecryptionPreviousCertPath();
            this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_active_previous_same, path, new Object[]{this.type, P_384_EC}));
        }
        if (this.p521ActiveCertId != null && this.p521ActiveCertId.equals(this.p521PreviousCertId)) {
            path = this.type == OAuthOidcKeysValidator.StaticKeyType.SIGNING ? OAuthOidcKeysPaths.getP521PreviousCertPath() : OAuthOidcKeysPaths.getP521DecryptionPreviousCertPath();
            this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_active_previous_same, path, new Object[]{this.type, P_521_EC}));
        }
        if (this.rsaActiveCertId != null && this.rsaActiveCertId.equals(this.rsaPreviousCertId)) {
            path = this.type == OAuthOidcKeysValidator.StaticKeyType.SIGNING ? OAuthOidcKeysPaths.getRsaPreviousCertPath() : OAuthOidcKeysPaths.getRsaDecryptionPreviousCertPath();
            this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_active_previous_same, path, new Object[]{this.type, "RSA"}));
        }
    }

    private void validatePrevious() {
        String path;
        if (StringUtils.isBlank((String)this.p256ActiveCertId) && StringUtils.isNotBlank((String)this.p256PreviousCertId)) {
            path = this.type == OAuthOidcKeysValidator.StaticKeyType.SIGNING ? OAuthOidcKeysPaths.getP256PreviousCertPath() : OAuthOidcKeysPaths.getP256DecryptionPreviousCertPath();
            this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_previous_empty, path, new Object[]{this.type, P_256_EC}));
        }
        if (StringUtils.isBlank((String)this.p384ActiveCertId) && StringUtils.isNotBlank((String)this.p384PreviousCertId)) {
            path = this.type == OAuthOidcKeysValidator.StaticKeyType.SIGNING ? OAuthOidcKeysPaths.getP384PreviousCertPath() : OAuthOidcKeysPaths.getP384DecryptionPreviousCertPath();
            this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_previous_empty, path, new Object[]{this.type, P_384_EC}));
        }
        if (StringUtils.isBlank((String)this.p521ActiveCertId) && StringUtils.isNotBlank((String)this.p521PreviousCertId)) {
            path = this.type == OAuthOidcKeysValidator.StaticKeyType.SIGNING ? OAuthOidcKeysPaths.getP521PreviousCertPath() : OAuthOidcKeysPaths.getP521DecryptionPreviousCertPath();
            this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_previous_empty, path, new Object[]{this.type, P_521_EC}));
        }
        if (StringUtils.isBlank((String)this.rsaActiveCertId) && StringUtils.isNotBlank((String)this.rsaPreviousCertId)) {
            path = this.type == OAuthOidcKeysValidator.StaticKeyType.SIGNING ? OAuthOidcKeysPaths.getRsaPreviousCertPath() : OAuthOidcKeysPaths.getRsaDecryptionPreviousCertPath();
            this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_previous_empty, path, new Object[]{this.type, "RSA"}));
        }
    }

    private void validatePublish() {
        String path;
        if (StringUtils.isBlank((String)this.p256ActiveCertId) && this.p256PublishX5cParameter) {
            path = this.type == OAuthOidcKeysValidator.StaticKeyType.SIGNING ? OAuthOidcKeysPaths.getP256PublishX5cParameterPath() : OAuthOidcKeysPaths.getP256DecryptionPublishX5cParameterPath();
            this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_publish_empty, path, new Object[]{this.type, P_256_EC}));
        }
        if (StringUtils.isBlank((String)this.p384ActiveCertId) && this.p384PublishX5cParameter) {
            path = this.type == OAuthOidcKeysValidator.StaticKeyType.SIGNING ? OAuthOidcKeysPaths.getP384PublishX5cParameterPath() : OAuthOidcKeysPaths.getP384DecryptionPublishX5cParameterPath();
            this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_publish_empty, path, new Object[]{this.type, P_384_EC}));
        }
        if (StringUtils.isBlank((String)this.p521ActiveCertId) && this.p521PublishX5cParameter) {
            path = this.type == OAuthOidcKeysValidator.StaticKeyType.SIGNING ? OAuthOidcKeysPaths.getP521PublishX5cParameterPath() : OAuthOidcKeysPaths.getP521DecryptionPublishX5cParameterPath();
            this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_publish_empty, path, new Object[]{this.type, P_521_EC}));
        }
        if (StringUtils.isBlank((String)this.rsaActiveCertId) && this.rsaPublishX5cParameter) {
            path = this.type == OAuthOidcKeysValidator.StaticKeyType.SIGNING ? OAuthOidcKeysPaths.getRsaPublishX5cParameterPath() : OAuthOidcKeysPaths.getRsaDecryptionPublishX5cParameterPath();
            this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_publish_empty, path, new Object[]{this.type, "RSA"}));
        }
    }

    public boolean validate() {
        if (this.staticJwksEnabled || this.isAdditionalKeyset) {
            this.validateKeysRequiredByJwtAtm();
            if (this.isAnyEmptyActiveCert()) {
                return false;
            }
            this.checkAnyActivePreviousCertsSame();
            this.validatePrevious();
            this.validatePublish();
            this.validateKeyIds();
        }
        return !this.hasErrors();
    }

    private void validateKeysRequiredByJwtAtm() {
        if (this.staticJwksEnabled && this.keysRequiredByJwtAtm) {
            HashSet<String> algoInUse = new HashSet<String>();
            Iterator iterator = this.bearerAccessTokenMgmtPluginManager.getInstances().iterator();
            while (iterator.hasNext()) {
                Field jwsAlgorithm;
                Field useCentralizedSigningKey;
                String pluginClassName = "com.pingidentity.pf.access.token.management.plugins.JwtBearerAccessTokenManagementPlugin";
                BearerAccessTokenMgmtPluginInstance instance = (BearerAccessTokenMgmtPluginInstance)iterator.next();
                if (!pluginClassName.equals(instance.getDescriptor().getPluginClassName()) || (useCentralizedSigningKey = instance.getAdminCompositeConfiguration().getField("Use Centralized Signing Key")) == null || !useCentralizedSigningKey.getValueAsBoolean() || (jwsAlgorithm = instance.getConfiguration().getField("JWS Algorithm")) == null) continue;
                algoInUse.add(jwsAlgorithm.getValue());
            }
            if (!algoInUse.isEmpty()) {
                if (algoInUse.contains("ES256") && StringUtils.isBlank((String)this.p256ActiveCertId)) {
                    this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_active_certs_required, OAuthOidcKeysPaths.getP256ActiveCertPath(), new Object[]{this.type, P_256_EC}));
                }
                if (algoInUse.contains("ES384") && StringUtils.isBlank((String)this.p384ActiveCertId)) {
                    this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_active_certs_required, OAuthOidcKeysPaths.getP384ActiveCertPath(), new Object[]{this.type, P_384_EC}));
                }
                if (algoInUse.contains("ES512") && StringUtils.isBlank((String)this.p521ActiveCertId)) {
                    this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_active_certs_required, OAuthOidcKeysPaths.getP521ActiveCertPath(), new Object[]{this.type, P_521_EC}));
                }
            }
        }
    }

    public static class Builder {
        private OAuthOidcKeysValidator.StaticKeyType type;
        private boolean staticJwksEnabled;
        private String p256ActiveCertId;
        private String p256PreviousCertId;
        private boolean p256PublishX5cParameter;
        private String p256ActiveKeyId;
        private String p256PreviousKeyId;
        private String p384ActiveCertId;
        private String p384PreviousCertId;
        private boolean p384PublishX5cParameter;
        private String p384ActiveKeyId;
        private String p384PreviousKeyId;
        private String p521ActiveCertId;
        private String p521PreviousCertId;
        private boolean p521PublishX5cParameter;
        private String p521ActiveKeyId;
        private String p521PreviousKeyId;
        private String rsaActiveCertId;
        private String rsaPreviousCertId;
        private boolean rsaPublishX5cParameter;
        private String rsaActiveKeyId;
        private String rsaPreviousKeyId;
        private boolean setSkipRsaValidation;
        private boolean keysRequiredByJwtAtm;
        private BearerAccessTokenMgmtPluginManager bearerAccessTokenMgmtPluginManager;
        private boolean isAdditionalKeyset;
        private List<RsaAlgKeyId> rsaAlgTypesActiveCustomKeyIds;
        private List<RsaAlgKeyId> rsaAlgTypesPreviousCustomKeyIds;

        public Builder() {
        }

        public Builder(OAuthOidcKeysValidator.StaticKeyType type, boolean isAdditionalKeyset) {
            this.type = type;
            this.isAdditionalKeyset = isAdditionalKeyset;
        }

        public Builder(OAuthOidcKeysValidator.StaticKeyType type) {
            this.type = type;
            this.isAdditionalKeyset = false;
        }

        public Builder setStaticJwksEnabled(boolean staticJwksEnabled) {
            this.staticJwksEnabled = staticJwksEnabled;
            return this;
        }

        public Builder setP256ActiveCertId(String p256ActiveCertId) {
            this.p256ActiveCertId = p256ActiveCertId;
            return this;
        }

        public Builder setP256PreviousCertId(String p256PreviousCertId) {
            this.p256PreviousCertId = p256PreviousCertId;
            return this;
        }

        public Builder setP256PublishX5cParameter(boolean p256PublishX5cParameter) {
            this.p256PublishX5cParameter = p256PublishX5cParameter;
            return this;
        }

        public Builder setP256ActiveKeyId(String p256ActiveKeyId) {
            this.p256ActiveKeyId = p256ActiveKeyId;
            return this;
        }

        public Builder setP256PreviousKeyId(String p256PreviousKeyId) {
            this.p256PreviousKeyId = p256PreviousKeyId;
            return this;
        }

        public Builder setP384ActiveCertId(String p384ActiveCertId) {
            this.p384ActiveCertId = p384ActiveCertId;
            return this;
        }

        public Builder setP384PreviousCertId(String p384PreviousCertId) {
            this.p384PreviousCertId = p384PreviousCertId;
            return this;
        }

        public Builder setP384PublishX5cParameter(boolean p384PublishX5cParameter) {
            this.p384PublishX5cParameter = p384PublishX5cParameter;
            return this;
        }

        public Builder setP384ActiveKeyId(String p384ActiveKeyId) {
            this.p384ActiveKeyId = p384ActiveKeyId;
            return this;
        }

        public Builder setP384PreviousKeyId(String p384PreviousKeyId) {
            this.p384PreviousKeyId = p384PreviousKeyId;
            return this;
        }

        public Builder setP521ActiveCertId(String p521ActiveCertId) {
            this.p521ActiveCertId = p521ActiveCertId;
            return this;
        }

        public Builder setP521PreviousCertId(String p521PreviousCertId) {
            this.p521PreviousCertId = p521PreviousCertId;
            return this;
        }

        public Builder setP521PublishX5cParameter(boolean p521PublishX5cParameter) {
            this.p521PublishX5cParameter = p521PublishX5cParameter;
            return this;
        }

        public Builder setP521ActiveKeyId(String p521ActiveKeyId) {
            this.p521ActiveKeyId = p521ActiveKeyId;
            return this;
        }

        public Builder setP521PreviousKeyId(String p521PreviousKeyId) {
            this.p521PreviousKeyId = p521PreviousKeyId;
            return this;
        }

        public Builder setRsaActiveCertId(String rsaActiveCertId) {
            this.rsaActiveCertId = rsaActiveCertId;
            return this;
        }

        public Builder setRsaPreviousCertId(String rsaPreviousCertId) {
            this.rsaPreviousCertId = rsaPreviousCertId;
            return this;
        }

        public Builder setRsaPublishX5cParameter(boolean rsaPublishX5cParameter) {
            this.rsaPublishX5cParameter = rsaPublishX5cParameter;
            return this;
        }

        public Builder setRsaActiveKeyId(String rsaActiveKeyId) {
            this.rsaActiveKeyId = rsaActiveKeyId;
            return this;
        }

        public Builder setRsaPreviousKeyId(String rsaPreviousKeyId) {
            this.rsaPreviousKeyId = rsaPreviousKeyId;
            return this;
        }

        public Builder setSkipRsaValidation(boolean skipRsaValidation) {
            this.setSkipRsaValidation = skipRsaValidation;
            return this;
        }

        public Builder setKeysRequiredByJwtAtm(BearerAccessTokenMgmtPluginManager bearerAccessTokenMgmtPluginManager) {
            this.keysRequiredByJwtAtm = true;
            this.bearerAccessTokenMgmtPluginManager = bearerAccessTokenMgmtPluginManager;
            return this;
        }

        public Builder setRsaAlgTypesPreviousCustomKeyIds(List<RsaAlgKeyId> rsaAlgTypesPreviousCustomKeyIds) {
            this.rsaAlgTypesPreviousCustomKeyIds = rsaAlgTypesPreviousCustomKeyIds;
            return this;
        }

        public Builder setRsaAlgTypesActiveCustomKeyIds(List<RsaAlgKeyId> rsaAlgTypesActiveCustomKeyIds) {
            this.rsaAlgTypesActiveCustomKeyIds = rsaAlgTypesActiveCustomKeyIds;
            return this;
        }

        public Builder setRsaAlgTypesPreviousCustomKeyIds(Map<String, String> rsaAlgTypesPreviousCustomKeyIds) {
            this.rsaAlgTypesPreviousCustomKeyIds = OAuthOidcKeysTranslator.populateApiRsAlgTypeToKeyIds(rsaAlgTypesPreviousCustomKeyIds);
            return this;
        }

        public Builder setRsaAlgTypesActiveCustomKeyIds(Map<String, String> rsaAlgTypesActiveCustomKeyIds) {
            this.rsaAlgTypesActiveCustomKeyIds = OAuthOidcKeysTranslator.populateApiRsAlgTypeToKeyIds(rsaAlgTypesActiveCustomKeyIds);
            return this;
        }

        public OAuthOidcKeysBaseValidator build() {
            return new OAuthOidcKeysBaseValidator(this);
        }
    }
}

