/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.model.fieldpaths.oauth.ResourceOwnerCredentialsMappingPaths;
import com.pingidentity.admin.api.model.oauth.ResourceOwnerCredentialsMapping;
import com.pingidentity.admin.api.model.oauth.SourceToUserKeyMapping;
import com.pingidentity.admin.api.validator.AttributeSetSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ContextSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.OAuthSourceToUserKeyValidator;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sourceid.saml20.domain.PasswordCredentialValidatorInstance;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PasswordCredentialValidatorManager;

public class OAuthRoCredsMappingValidator
extends OAuthSourceToUserKeyValidator {
    private static final PasswordCredentialValidatorManager PASSWORD_CREDENTIAL_VALIDATOR_MANAGER = MgmtFactory.getCredentialValidatorManager();
    private PasswordCredentialValidatorInstance instance;
    private SourceToUserKeyMapping mapping;

    public OAuthRoCredsMappingValidator(ResourceOwnerCredentialsMapping mapping, ValidatorContext context) {
        super(mapping, context);
    }

    @Override
    protected void init(SourceToUserKeyMapping mapping) {
        this.instance = (PasswordCredentialValidatorInstance)PASSWORD_CREDENTIAL_VALIDATOR_MANAGER.getInstance(mapping.getId());
        this.mapping = mapping;
    }

    @Override
    public boolean validate() {
        if (this.instance == null || !this.instance.getId().equals(this.mapping.getId())) {
            this.appendError(ApiMessageKey.password_credential_validator_not_found, ResourceOwnerCredentialsMappingPaths.getId(), this.mapping.getId());
            return false;
        }
        super.validate();
        return !this.hasErrors();
    }

    private SourceTypeValidatorBuilder createPasswordCredentialValidatorTypeBuilder() {
        if (this.instance == null) {
            return null;
        }
        Set srcNames = this.instance.getAttributeContract().getAllAttributeNames();
        return new AttributeSetSourceTypeValidatorBuilder(srcNames, SourceType.PASSWORD_CREDENTIAL_VALIDATOR);
    }

    private void appendError(ApiMessageKey errorId, String fieldPath, Object ... params) {
        this.appendError(ValidationErrorFactory.getInstance().create(errorId, fieldPath, params));
    }

    @Override
    protected Set<String> getSourceCoreSubstitutionVariables() {
        if (this.instance == null) {
            return null;
        }
        return this.instance.getAttributeContract().getAllAttributeNames();
    }

    @Override
    protected void addAdditionalSourceValidators(Map<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources) {
        SourceTypeValidatorBuilder builder = this.createPasswordCredentialValidatorTypeBuilder();
        if (builder != null) {
            validSources.put(new SourceTypeIdKey(SourceType.PASSWORD_CREDENTIAL_VALIDATOR), builder);
        }
    }

    @Override
    protected String getSourceName() {
        return "password credential validator";
    }

    @Override
    protected Set<String> getAllAttributeNames() {
        return new HashSet<String>(AUTHZ_SERVER_MANAGER.getKeyOnlyContract().getAllAttrNamesSorted());
    }

    @Override
    protected ContextSourceTypeValidatorBuilder createContextTypeBuilder() {
        ContextSourceTypeValidatorBuilder builder = new ContextSourceTypeValidatorBuilder();
        builder.setContextSources(SourceContextType.getContextTypesForROPCToGrantMapping());
        return builder;
    }
}

