/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.model.fieldpaths.oauth.OAuthTeppMappingPaths;
import com.pingidentity.admin.api.model.oauth.ProcessorPolicyToPersistentGrantMapping;
import com.pingidentity.admin.api.model.oauth.SourceToUserKeyMapping;
import com.pingidentity.admin.api.validator.AttributeSetSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.OAuthSourceToUserKeyValidator;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.Map;
import java.util.Set;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorPolicy;
import org.sourceid.oauth20.exchange.manager.TokenExchangeProcessorPolicyManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class OAuthTeppMappingValidator
extends OAuthSourceToUserKeyValidator {
    private static final TokenExchangeProcessorPolicyManager processorPolicyManager = MgmtFactory.getTokenExchangeProcessorPolicyManager();
    private TokenExchangeProcessorPolicy instance;
    private String mappingId;

    public OAuthTeppMappingValidator(ProcessorPolicyToPersistentGrantMapping mapping, ValidatorContext context) {
        super(mapping, context);
        this.mappingId = mapping.getId();
    }

    @Override
    protected void init(SourceToUserKeyMapping mapping) {
        ResourceLink ref = ((ProcessorPolicyToPersistentGrantMapping)mapping).getProcessorPolicyRef();
        if (ref != null) {
            this.mappingId = ref.getId();
            if (this.mappingId != null) {
                this.instance = processorPolicyManager.getPolicyById(this.mappingId);
            }
        }
    }

    @Override
    public boolean validate() {
        if (this.mappingId == null) {
            this.appendError(ApiMessageKey.oauth_tepp_mapping_tepp_id_required, OAuthTeppMappingPaths.getProcessorPolicyRefId(), new Object[0]);
            return false;
        }
        if (this.instance == null) {
            this.appendError(ApiMessageKey.token_exchange_processor_policy_not_found, OAuthTeppMappingPaths.getProcessorPolicyRefId(), this.mappingId);
            return false;
        }
        super.validate();
        return !this.hasErrors();
    }

    private void appendError(ApiMessageKey errorId, String fieldPath, Object ... params) {
        this.appendError(ValidationErrorFactory.getInstance().create(errorId, fieldPath, params));
    }

    @Override
    protected Set<String> getSourceCoreSubstitutionVariables() {
        if (this.instance == null) {
            return null;
        }
        return this.instance.getContract().getAllAttributeNames();
    }

    private AttributeSetSourceTypeValidatorBuilder createContractTypeBuilder() {
        if (this.instance == null) {
            return null;
        }
        Set srcNames = this.instance.getContract().getAllAttributeNames();
        return new AttributeSetSourceTypeValidatorBuilder(srcNames, SourceType.TOKEN_EXCHANGE_PROCESSOR_POLICY);
    }

    @Override
    protected void addAdditionalSourceValidators(Map<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources) {
        AttributeSetSourceTypeValidatorBuilder builder = this.createContractTypeBuilder();
        if (builder != null) {
            validSources.put(new SourceTypeIdKey(SourceType.TOKEN_EXCHANGE_PROCESSOR_POLICY), builder);
        }
    }

    @Override
    protected String getSourceName() {
        return "processor policy";
    }
}

