/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.IdpConnection;
import com.pingidentity.admin.api.model.OIDCProviderSettings;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.util.Obfuscator;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import org.apache.commons.lang.StringUtils;

public class OIDCClientCredentialValidator
extends AbstractValidator {
    public IdpConnection connection;

    public OIDCClientCredentialValidator(IdpConnection apiIdpConnection) {
        this.connection = apiIdpConnection;
    }

    public boolean validate() {
        if (this.connection.getBrowserSso() != null) {
            if (this.connection.getBrowserSso().getProtocol() == Protocol.OIDC) {
                OIDCProviderSettings oidcProviderSettings = this.connection.getIdpBrowserSso().getOidcProviderSettings();
                if (this.connection.getOidcClientCredentials() == null) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_required, ConnectionPaths.getOIDCClientCredentialSettings(), new Object[]{ConnectionPaths.getOIDCClientCredentialSettings()}));
                } else if (StringUtils.isEmpty((String)this.connection.getOidcClientCredentials().getClientId())) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_required, ConnectionPaths.getOIDCClientId(), new Object[]{ConnectionPaths.getOIDCClientId()}));
                } else if (StringUtils.isNotEmpty((String)this.connection.getOidcClientCredentials().getEncryptedSecret())) {
                    try {
                        String encryptedSecret = this.connection.getOidcClientCredentials().getEncryptedSecret();
                        Obfuscator.deobfuscate((String)encryptedSecret);
                    }
                    catch (Exception e) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_encrypted_secret_invalid, ConnectionPaths.getOIDCClientCredentialSettings(), new Object[]{ConnectionPaths.getOIDCClientCredentialSettings()}));
                    }
                }
            } else if (this.connection.getOidcClientCredentials() != null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, ConnectionPaths.getOIDCClientCredentialSettings(), new Object[]{ConnectionPaths.getOIDCClientCredentialSettings()}));
            }
        }
        return !this.hasErrors();
    }
}

