/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.IdpConnection;
import com.pingidentity.admin.api.model.OIDCAuthenticationScheme;
import com.pingidentity.admin.api.model.OIDCLoginType;
import com.pingidentity.admin.api.model.OIDCProviderSettings;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.model.fieldpaths.OpenIdConnectMetadataPaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.OpenIdMetadataValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import org.apache.commons.lang.StringUtils;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderInfo;

public class OIDCProviderValidator
extends CompositeValidator {
    private IdpConnection connection;

    public OIDCProviderValidator(IdpConnection connection, ValidatorContext context) {
        this.connection = connection;
        boolean isBaseUrlConfigured = StringUtils.isNotBlank((String)connection.getBaseUrl());
        OIDCProviderSettings providerSettings = connection.getIdpBrowserSso().getOidcProviderSettings();
        if (providerSettings != null && connection.getIdpBrowserSso().getProtocol() == Protocol.OIDC) {
            OpenIdMetadataValidator validator = new OpenIdMetadataValidator(providerSettings, isBaseUrlConfigured, context);
            this.addValidator((Validator)validator);
        }
    }

    @Override
    public boolean validate() {
        super.validate();
        OIDCProviderSettings providerSettings = this.connection.getIdpBrowserSso().getOidcProviderSettings();
        if (this.connection.getIdpBrowserSso().getProtocol() != Protocol.OIDC) {
            if (providerSettings != null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, ConnectionPaths.getBrowserSSOOidcSettings(), new Object[]{ConnectionPaths.getBrowserSSOOidcSettings()}));
            }
        } else {
            if (providerSettings == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_required, ConnectionPaths.getBrowserSSOOidcSettings(), new Object[]{ConnectionPaths.getBrowserSSOOidcSettings()}));
            } else if (providerSettings.getAuthenticationScheme() == null && providerSettings.getLoginType() == OIDCLoginType.CODE) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_authentication_scheme_required, OpenIdConnectMetadataPaths.getAuthenticationScheme(), new Object[]{OIDCLoginType.CODE}));
            }
            if (providerSettings != null && providerSettings.getLoginType() == OIDCLoginType.CODE) {
                if (providerSettings.getAuthenticationScheme() == OIDCAuthenticationScheme.PRIVATE_KEY_JWT) {
                    if (providerSettings.getAuthenticationSigningAlgorithm() != null && !OpenIdConnectProviderInfo.getSupportedAsymmetricSignatureVerificationAlgorithms().keySet().contains(providerSettings.getAuthenticationSigningAlgorithm().getId())) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_authentication_signing_algorithm_invalid, OpenIdConnectMetadataPaths.getSigningAlgorithm(), new Object[]{"Authentication Signing Algorithm"}));
                    }
                } else if (providerSettings.getAuthenticationScheme() == OIDCAuthenticationScheme.CLIENT_SECRET_JWT && providerSettings.getAuthenticationSigningAlgorithm() != null && !OpenIdConnectProviderInfo.getSupportedSymmetricSignatureVerificationAlgorithms().keySet().contains(providerSettings.getAuthenticationSigningAlgorithm().getId())) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_authentication_symmetric_signing_algorithm_invalid, OpenIdConnectMetadataPaths.getSigningAlgorithm(), new Object[]{"Authentication Signing Algorithm"}));
                }
            }
            if (providerSettings != null && providerSettings.getRequestSigningAlgorithm() != null && !OpenIdConnectProviderInfo.idTokenSigningAlgValuesSupported().contains(providerSettings.getRequestSigningAlgorithm().getId())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_request_signing_algorithm_invalid, OpenIdConnectMetadataPaths.getRequestObjectSigningAlgorithm(), new Object[]{"Request Signing Algorithm"}));
            }
        }
        return !this.hasErrors();
    }
}

