/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.PluginInstancePaths;
import com.pingidentity.admin.api.model.plugin.OutOfBandAuthAttribute;
import com.pingidentity.admin.api.model.plugin.OutOfBandAuthenticator;
import com.pingidentity.admin.api.translator.plugin.PluginEnum;
import com.pingidentity.admin.api.validator.AttributeContractValidator;
import com.pingidentity.admin.api.validator.PluginInstanceValidator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import com.pingidentity.sdk.PluginDescriptor;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.mgmt.PluginManager;

public class OOBAuthenticatorValidator
extends PluginInstanceValidator {
    private final OutOfBandAuthenticator apiOOBAuthenticator;

    public OOBAuthenticatorValidator(OutOfBandAuthenticator apiInstance, PluginManager<?, ?> manager, boolean isCreate, PluginEnum pluginType, ValidatorContext validatorContext) {
        super(apiInstance, manager, isCreate, pluginType, validatorContext);
        this.apiOOBAuthenticator = apiInstance;
    }

    @Override
    public boolean validate() {
        super.validate();
        this.validateContract();
        return !this.hasErrors();
    }

    private void validateContract() {
        if (this.apiOOBAuthenticator.getAttributeContract() == null || (this.apiOOBAuthenticator.getAttributeContract().getCoreAttributes() == null || this.apiOOBAuthenticator.getAttributeContract().getCoreAttributes().isEmpty()) && (this.apiOOBAuthenticator.getAttributeContract().getExtendedAttributes() == null || this.apiOOBAuthenticator.getAttributeContract().getExtendedAttributes().isEmpty())) {
            return;
        }
        boolean pluginAllowsExtAttrs = true;
        Set coreAttrs = new HashSet();
        LinkedList<OutOfBandAuthAttribute> attributes = new LinkedList<OutOfBandAuthAttribute>();
        String pluginTypeId = null;
        if (this.apiOOBAuthenticator.getPluginDescriptorRef() != null) {
            pluginTypeId = this.apiOOBAuthenticator.getPluginDescriptorRef().getId();
        }
        if (pluginTypeId != null) {
            for (PluginDescriptor pluginDescriptor : PluginEnum.OOB_AUTHENTICATOR.getPluginManager().getInstalledDescriptors()) {
                if (!pluginDescriptor.getPluginClassName().equals(pluginTypeId)) continue;
                Set descriptorAttrs = pluginDescriptor.getAttributeContractSet();
                if (descriptorAttrs != null) {
                    coreAttrs = descriptorAttrs;
                }
                pluginAllowsExtAttrs = pluginDescriptor.isSupportsExtendedContract();
                break;
            }
        }
        int i = 0;
        for (OutOfBandAuthAttribute coreAttr : this.apiOOBAuthenticator.getAttributeContract().getCoreAttributes()) {
            attributes.add(coreAttr);
            if (StringUtils.isNotBlank((String)coreAttr.getName()) && !coreAttrs.contains(coreAttr.getName())) {
                this.appendError(this.errorFactory.create(ApiMessageKey.attribute_contract_unknown_core_attribute, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.AttributeContractPaths.getCoreContractAttribute(i)), new Object[]{coreAttr.getName()}));
            }
            ++i;
        }
        List<OutOfBandAuthAttribute> extendedAttrs = this.apiOOBAuthenticator.getAttributeContract().getExtendedAttributes();
        if (!pluginAllowsExtAttrs && extendedAttrs != null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.plugin_descriptor_ext_attrs_not_supported, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.AttributeContractPaths.getExtendedContractAttributes())));
        }
        AttributeContractValidator<OutOfBandAuthAttribute> attributeContractValidator = new AttributeContractValidator<OutOfBandAuthAttribute>(attributes, extendedAttrs, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.AttributeContractPaths.getAttributeContract()));
        attributeContractValidator.validate();
        this.appendErrors(attributeContractValidator.getErrors());
    }
}

