/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.oauth.AuthorizationServerSettingsPaths;
import com.pingidentity.admin.api.model.fieldpaths.oauth.ScopeEntryPath;
import com.pingidentity.admin.api.model.fieldpaths.oauth.ScopeGroupEntryPath;
import com.pingidentity.admin.api.model.oauth.OAuthScopes;
import com.pingidentity.admin.api.model.oauth.ScopeEntry;
import com.pingidentity.admin.api.model.oauth.ScopeGroupEntry;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.ScopeUtil;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class OauthScopeValidator
extends AbstractValidator {
    private List<ScopeEntry> scopes;
    private List<ScopeGroupEntry> scopeGroups;
    private List<ScopeEntry> exclusiveScopes;
    private List<ScopeGroupEntry> exclusiveScopeGroups;
    private boolean validateCommonScopes = true;
    private boolean validateExclusiveScopes = true;
    private String scopeForOAuthGrantManagement;
    boolean isNestedApi = false;
    private final AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();

    public boolean isNestedApi() {
        return this.isNestedApi;
    }

    public void setNestedApi(boolean nestedApi) {
        this.isNestedApi = nestedApi;
    }

    public OauthScopeValidator(List<ScopeEntry> scopes, List<ScopeGroupEntry> scopeGroups, List<ScopeEntry> exclusiveScopes, List<ScopeGroupEntry> exclusiveScopeGroups, String scopeForOAuthGrantManagement) {
        this.scopes = scopes;
        this.scopeGroups = scopeGroups;
        this.exclusiveScopes = exclusiveScopes;
        this.exclusiveScopeGroups = exclusiveScopeGroups;
        this.scopeForOAuthGrantManagement = scopeForOAuthGrantManagement;
    }

    public OauthScopeValidator(OAuthScopes scopeSettings, boolean isNestedApi, boolean validateCommonScopes, boolean validateExclusiveScopes) {
        this.scopes = scopeSettings.getScopes();
        this.scopeGroups = scopeSettings.getScopeGroups();
        this.exclusiveScopes = scopeSettings.getExclusiveScopes();
        this.exclusiveScopeGroups = scopeSettings.getExclusiveScopeGroups();
        this.isNestedApi = isNestedApi;
        this.validateExclusiveScopes = validateExclusiveScopes;
        this.validateCommonScopes = validateCommonScopes;
        this.scopeForOAuthGrantManagement = this.authzServerManager.getScopeForOAuthGrantManagement();
    }

    public boolean validate() {
        this.validateScopeSettings(this.validateCommonScopes, this.validateExclusiveScopes, true, true);
        return !this.hasErrors();
    }

    public boolean validateScopes() {
        this.validateScopeSettings(this.validateCommonScopes, this.validateExclusiveScopes, true, false);
        return !this.hasErrors();
    }

    public boolean validateScopeGroups() {
        this.validateScopeSettings(this.validateCommonScopes, this.validateExclusiveScopes, false, true);
        return !this.hasErrors();
    }

    private void validateScopeSettings(boolean validateCommonScopes, boolean validateExclusiveScopes, boolean includeScopeErrors, boolean includeScopeGroupErrors) {
        HashSet<String> allScopes = new HashSet<String>();
        HashSet<String> allCommonScopeNames = new HashSet();
        HashSet<String> allCommonScopeGroupNames = new HashSet();
        Set<String> allExclusiveScopeNames = new HashSet<String>();
        Set<String> allExclusiveScopeGroupNames = new HashSet<String>();
        if (this.scopes != null) {
            allCommonScopeNames = this.scopes.parallelStream().map(ScopeEntry::getName).collect(Collectors.toSet());
            allScopes.addAll(allCommonScopeNames);
        }
        if (this.scopeGroups != null) {
            allCommonScopeGroupNames = this.scopeGroups.parallelStream().map(ScopeGroupEntry::getName).collect(Collectors.toSet());
            allScopes.addAll(allCommonScopeGroupNames);
        }
        if (this.exclusiveScopes != null) {
            allExclusiveScopeNames = this.exclusiveScopes.parallelStream().map(ScopeEntry::getName).collect(Collectors.toSet());
            allScopes.addAll(allExclusiveScopeNames);
        }
        if (this.exclusiveScopeGroups != null) {
            allExclusiveScopeGroupNames = this.exclusiveScopeGroups.parallelStream().map(ScopeGroupEntry::getName).collect(Collectors.toSet());
            allScopes.addAll(allExclusiveScopeGroupNames);
        }
        if (validateCommonScopes) {
            this.validateCommonScopes(allCommonScopeGroupNames, allExclusiveScopeNames, allExclusiveScopeGroupNames, includeScopeErrors);
            this.validateCommonScopeGroup(allCommonScopeNames, allExclusiveScopeNames, allExclusiveScopeGroupNames, includeScopeGroupErrors);
        }
        if (validateExclusiveScopes) {
            this.validateExclusiveScope(allExclusiveScopeGroupNames, allCommonScopeNames, allCommonScopeGroupNames, includeScopeErrors);
            this.validateExclusiveScopeGroup(allExclusiveScopeNames, allCommonScopeNames, allCommonScopeGroupNames, includeScopeGroupErrors);
        }
        if (StringUtils.isNotBlank((String)this.scopeForOAuthGrantManagement) && !allScopes.contains(this.scopeForOAuthGrantManagement)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_scope_used_by_oauth_grant_management, AuthorizationServerSettingsPaths.getScopeForOAuthGrantManagementPath()));
        }
    }

    private Set<String> getExclusiveDynamicScopes() {
        if (this.exclusiveScopes == null) {
            return Collections.emptySet();
        }
        return this.exclusiveScopes.stream().filter(scope -> BooleanUtils.isTrue((Boolean)scope.isDynamic())).map(ScopeEntry::getName).collect(Collectors.toSet());
    }

    private void validateExclusiveScopeGroup(Set<String> allExclusiveScopeNames, Set<String> allCommonScopeNames, Set<String> allCommonScopeGroupNames, boolean includeErrors) {
        if (this.exclusiveScopeGroups == null) {
            return;
        }
        HashSet<String> exclusiveScopeGroupNames = new HashSet<String>();
        int index = 0;
        for (ScopeGroupEntry scopeGroup : this.exclusiveScopeGroups) {
            if (StringUtils.isBlank((String)scopeGroup.getName()) && includeErrors) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_scope_group_name_required, this.getScopeGroupNamePath(index)));
            } else if (!scopeGroup.getName().matches(this.authzServerManager.getScopeWhitelist()) && includeErrors) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_scope_group_name_invalid, this.getScopeGroupNamePath(index), new Object[]{scopeGroup.getName()}));
            }
            if (StringUtils.isBlank((String)scopeGroup.getDescription()) && includeErrors) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_scope_group_description_required, this.getGroupDescriptionPath(index)));
            }
            if (!exclusiveScopeGroupNames.add(scopeGroup.getName()) && includeErrors) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_scope_group_name_already_defined, this.getScopeGroupNamePath(index), new Object[]{scopeGroup.getName()}));
            }
            if (scopeGroup.getScopes() != null && !scopeGroup.getScopes().isEmpty()) {
                if (!allExclusiveScopeNames.containsAll(scopeGroup.getScopes()) && includeErrors) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_scope_group_invalid_scopes, this.getGroupScopesPath(index), new Object[]{scopeGroup.getName()}));
                }
                Set<String> exclusiveDynamicScopes = this.getExclusiveDynamicScopes();
                for (String scope : scopeGroup.getScopes()) {
                    if (!exclusiveDynamicScopes.contains(scope) || !includeErrors) continue;
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_scope_group_invalid_dynamic_scopes, this.getGroupScopesPath(index), new Object[]{scopeGroup.getName(), scope}));
                }
            }
            if (allExclusiveScopeNames.contains(scopeGroup.getName()) && includeErrors) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_scope_name_already_defined_in_exclusive, this.getScopeNamePath(index), new Object[]{scopeGroup.getName()}));
            }
            if (allCommonScopeNames.contains(scopeGroup.getName()) && includeErrors) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_scope_name_already_defined_in_common, this.getScopeNamePath(index), new Object[]{scopeGroup.getName()}));
            }
            if (allCommonScopeGroupNames.contains(scopeGroup.getName()) && includeErrors) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_scope_name_already_defined_in_common_group, this.getScopeNamePath(index), new Object[]{scopeGroup.getName()}));
            }
            ++index;
        }
    }

    private void validateExclusiveScope(Set<String> allExclusiveScopeGroupNames, Set<String> allCommonScopeNames, Set<String> allCommonScopeGroupNames, boolean includeErrors) {
        if (this.exclusiveScopes == null) {
            return;
        }
        HashSet<String> exclusiveScopesSeen = new HashSet<String>();
        int index = 0;
        for (ScopeEntry scope : this.exclusiveScopes) {
            if (StringUtils.isBlank((String)scope.getName()) && includeErrors) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_scope_name_required, this.getScopeNamePath(index)));
            } else if (!scope.getName().matches(this.authzServerManager.getScopeWhitelist()) && includeErrors) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_scope_name_invalid, this.getScopeNamePath(index), new Object[]{scope.getName()}));
            }
            if (BooleanUtils.isTrue((Boolean)scope.isDynamic())) {
                if (!ScopeUtil.DynamicScope.isValid((String)scope.getName()) && includeErrors) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_dynamic_scope_name_invalid, this.getScopeNamePath(index), new Object[]{scope.getName()}));
                }
                if (this.exclusiveScopeGroups != null) {
                    for (ScopeGroupEntry exclusiveScopeGroup : this.exclusiveScopeGroups) {
                        if (exclusiveScopeGroup.getScopes() == null || !exclusiveScopeGroup.getScopes().contains(scope.getName()) || !includeErrors) continue;
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_scope_invalid_dynamic_scope_update, this.getDynamicFlagPath(index), new Object[]{scope.getName(), exclusiveScopeGroup.getName()}));
                    }
                }
            }
            if (StringUtils.isBlank((String)scope.getDescription()) && includeErrors) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_scope_description_required, this.getScopeDescriptionPath(index)));
            }
            if (!exclusiveScopesSeen.add(scope.getName()) && includeErrors) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_scope_name_already_defined, this.getScopeNamePath(index), new Object[]{scope.getName()}));
            }
            if (allExclusiveScopeGroupNames.contains(scope.getName()) && includeErrors) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_scope_name_already_defined_in_exclusive_group, this.getScopeNamePath(index), new Object[]{scope.getName()}));
            }
            if (allCommonScopeNames.contains(scope.getName()) && includeErrors) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_scope_name_already_defined_in_common, this.getScopeNamePath(index), new Object[]{scope.getName()}));
            }
            if (allCommonScopeGroupNames.contains(scope.getName()) && includeErrors) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_scope_name_already_defined_in_common_group, this.getScopeNamePath(index), new Object[]{scope.getName()}));
            }
            ++index;
        }
    }

    private Set<String> getCommonDynamicScopes() {
        if (this.scopes == null) {
            return Collections.emptySet();
        }
        return this.scopes.stream().filter(scope -> BooleanUtils.isTrue((Boolean)scope.isDynamic())).map(ScopeEntry::getName).collect(Collectors.toSet());
    }

    private void validateCommonScopeGroup(Set<String> allCommonScopeNames, Set<String> allExclusiveScopeNames, Set<String> allExclusiveScopeGroupNames, boolean includeErrors) {
        if (this.scopeGroups == null) {
            return;
        }
        HashSet<String> scopeGroupNames = new HashSet<String>();
        int index = 0;
        for (ScopeGroupEntry scopeGroup : this.scopeGroups) {
            if (StringUtils.isBlank((String)scopeGroup.getName()) && includeErrors) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_scope_group_name_required, this.getScopeGroupNamePath(index)));
            } else if (!scopeGroup.getName().matches(this.authzServerManager.getScopeWhitelist()) && includeErrors) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_scope_group_name_invalid, this.getScopeGroupNamePath(index), new Object[]{scopeGroup.getName()}));
            }
            if (StringUtils.isBlank((String)scopeGroup.getDescription()) && includeErrors) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_scope_group_description_required, this.getGroupDescriptionPath(index)));
            }
            if (!scopeGroupNames.add(scopeGroup.getName()) && includeErrors) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_scope_group_name_already_defined, this.getScopeGroupNamePath(index), new Object[]{scopeGroup.getName()}));
            }
            if (scopeGroup.getScopes() != null && !scopeGroup.getScopes().isEmpty()) {
                if (!allCommonScopeNames.containsAll(scopeGroup.getScopes()) && includeErrors) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_scope_group_invalid_scopes, this.getGroupScopesPath(index), new Object[]{scopeGroup.getName()}));
                }
                Set<String> commonDynamicScopes = this.getCommonDynamicScopes();
                for (String scope : scopeGroup.getScopes()) {
                    if (!commonDynamicScopes.contains(scope) || !includeErrors) continue;
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_scope_group_invalid_dynamic_scopes, this.getGroupScopesPath(index), new Object[]{scopeGroup.getName(), scope}));
                }
            }
            if (allCommonScopeNames.contains(scopeGroup.getName()) && includeErrors) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_scope_name_already_defined_in_common, this.getScopeNamePath(index), new Object[]{scopeGroup.getName()}));
            }
            if (allExclusiveScopeNames.contains(scopeGroup.getName()) && includeErrors) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_scope_name_already_defined_in_exclusive, this.getScopeNamePath(index), new Object[]{scopeGroup.getName()}));
            }
            if (allExclusiveScopeGroupNames.contains(scopeGroup.getName()) && includeErrors) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_scope_name_already_defined_in_exclusive_group, this.getScopeNamePath(index), new Object[]{scopeGroup.getName()}));
            }
            ++index;
        }
    }

    private void validateCommonScopes(Set<String> allCommonScopeGroupNames, Set<String> allExclusiveScopeNames, Set<String> allExclusiveScopeGroupNames, boolean includeErrors) {
        if (this.scopes == null) {
            return;
        }
        HashSet<String> commonScopesSeen = new HashSet<String>();
        int index = 0;
        for (ScopeEntry scope : this.scopes) {
            if (StringUtils.isBlank((String)scope.getName()) && includeErrors) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_scope_name_required, this.getScopeNamePath(index)));
            } else {
                if (!scope.getName().matches(this.authzServerManager.getScopeWhitelist()) && includeErrors) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_scope_name_invalid, this.getScopeNamePath(index), new Object[]{scope.getName()}));
                }
                if (BooleanUtils.isTrue((Boolean)scope.isDynamic())) {
                    if (!ScopeUtil.DynamicScope.isValid((String)scope.getName()) && includeErrors) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_dynamic_scope_name_invalid, this.getScopeNamePath(index), new Object[]{scope.getName()}));
                    }
                    if (this.scopeGroups != null) {
                        for (ScopeGroupEntry commonScopeGroup : this.scopeGroups) {
                            if (commonScopeGroup.getScopes() == null || !commonScopeGroup.getScopes().contains(scope.getName()) || !includeErrors) continue;
                            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_scope_invalid_dynamic_scope_update, this.getDynamicFlagPath(index), new Object[]{scope.getName(), commonScopeGroup.getName()}));
                        }
                    }
                }
            }
            if (StringUtils.isBlank((String)scope.getDescription()) && includeErrors) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_scope_description_required, this.getScopeDescriptionPath(index)));
            }
            if (!commonScopesSeen.add(scope.getName()) && includeErrors) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_scope_name_already_defined, this.getScopeNamePath(index), new Object[]{scope.getName()}));
            }
            if (allCommonScopeGroupNames.contains(scope.getName()) && includeErrors) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_scope_name_already_defined_in_common_group, this.getScopeNamePath(index), new Object[]{scope.getName()}));
            }
            if (allExclusiveScopeNames.contains(scope.getName()) && includeErrors) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_scope_name_already_defined_in_exclusive, this.getScopeNamePath(index), new Object[]{scope.getName()}));
            }
            if (allExclusiveScopeGroupNames.contains(scope.getName()) && includeErrors) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_scope_name_already_defined_in_exclusive_group, this.getScopeNamePath(index), new Object[]{scope.getName()}));
            }
            ++index;
        }
    }

    private String getScopeNamePath(int index) {
        if (this.isNestedApi) {
            return ScopeEntryPath.getName();
        }
        return AuthorizationServerSettingsPaths.getScopeName(index);
    }

    private String getDynamicFlagPath(int index) {
        if (this.isNestedApi) {
            return ScopeEntryPath.getDynamicFlag();
        }
        return AuthorizationServerSettingsPaths.getScopeDynamicFlag(index);
    }

    private String getScopeGroupNamePath(int index) {
        if (this.isNestedApi) {
            return ScopeGroupEntryPath.getName();
        }
        return AuthorizationServerSettingsPaths.getScopeGroupName(index);
    }

    private String getGroupScopesPath(int index) {
        if (this.isNestedApi) {
            return ScopeGroupEntryPath.getScopes();
        }
        return AuthorizationServerSettingsPaths.getScopeGroupScopes(index);
    }

    private String getScopeDescriptionPath(int index) {
        if (this.isNestedApi) {
            return ScopeEntryPath.getDescription();
        }
        return AuthorizationServerSettingsPaths.getScopeDescription(index);
    }

    private String getGroupDescriptionPath(int index) {
        if (this.isNestedApi) {
            return ScopeGroupEntryPath.getDescription();
        }
        return AuthorizationServerSettingsPaths.getScopeGroupDescription(index);
    }
}

