/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.X509File;
import com.pingidentity.admin.api.model.fieldpaths.X509FilePaths;
import com.pingidentity.admin.api.validator.CertificateValidator;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.IdValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.crypto.Cert;
import com.pingidentity.pf.common.api.validator.Validator;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.mgmt.PkCertAndConnectionCertManager;

public class OcspCertificateValidator
extends CompositeValidator {
    String id;
    PkCertAndConnectionCertManager certManager;
    X509File x509File;
    Cert cert;

    public OcspCertificateValidator(X509File x509File, PkCertAndConnectionCertManager certManager) {
        this.certManager = certManager;
        this.x509File = x509File;
        this.id = x509File.getId();
    }

    @Override
    public boolean validate() {
        if (StringUtils.isNotBlank((String)this.id)) {
            this.addValidator((Validator)new IdValidator(this.id, true, true, 0, 33, X509FilePaths.getId()));
            this.duplicateIdCheck(this.id);
        }
        CertificateValidator certificateValidator = new CertificateValidator(this.x509File.getFileData(), X509FilePaths.getFileData(), (Set<Cert>)this.certManager.getCertsForFeature("Revocation Settings OCSP Responder Certs"), false);
        certificateValidator.setValidateCryptoProvider(false);
        certificateValidator.setCryptoProvider(this.x509File.getCryptoProvider());
        this.addValidator((Validator)certificateValidator);
        super.validate();
        this.cert = certificateValidator.getCert();
        return !this.hasErrors();
    }

    public Cert getCert() {
        return this.cert;
    }

    private void duplicateIdCheck(String id) {
        Set existingCerts = this.certManager.getCertsForFeature("Revocation Settings OCSP Responder Certs");
        for (Cert cert : existingCerts) {
            if (!id.equals(cert.getAlias())) continue;
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.duplicate_ocsp_cert_alias, X509FilePaths.getId()));
            break;
        }
    }
}

