/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.model.AttributeMapping;
import com.pingidentity.admin.api.model.AttributeSource;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.model.fieldpaths.oauth.OpenIdConnectPolicyPaths;
import com.pingidentity.admin.api.model.oauth.OpenIdConnectAttribute;
import com.pingidentity.admin.api.model.oauth.OpenIdConnectPolicy;
import com.pingidentity.admin.api.validator.AttributeMappingValidator;
import com.pingidentity.admin.api.validator.BaseAttributeDataSourceValidator;
import com.pingidentity.admin.api.validator.ContextSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ExpressionSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ExtendedMetadataSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.NoMappingTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.admin.api.validator.PersistentGrantSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.TextSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.TokenSourceTypeValidatorBuilder;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.sourceid.openid.connect.domain.UserInfoAttrContract;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class OpenIdConnectAttributeMappingValidator
extends BaseAttributeDataSourceValidator {
    public OpenIdConnectAttributeMappingValidator(OpenIdConnectPolicy policy, ValidatorContext context) {
        super(context);
        TokenSourceTypeValidatorBuilder tokenSourceTypeValidatorBuilder = this.createTokenTypeBuilder(policy.getAccessTokenManagerRef().getId());
        HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> rootSources = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>();
        rootSources.put(new SourceTypeIdKey(SourceType.CONTEXT), this.createContextTypeBuilder());
        rootSources.put(new SourceTypeIdKey(SourceType.EXTENDED_CLIENT_METADATA), new ExtendedMetadataSourceTypeValidatorBuilder());
        rootSources.put(new SourceTypeIdKey(SourceType.EXTENDED_PROPERTIES), new ExtendedMetadataSourceTypeValidatorBuilder(SourceType.EXTENDED_PROPERTIES));
        rootSources.put(new SourceTypeIdKey(SourceType.NO_MAPPING), new NoMappingTypeValidatorBuilder());
        rootSources.put(new SourceTypeIdKey(SourceType.TEXT), this.createTextValBuilder());
        rootSources.put(new SourceTypeIdKey(SourceType.TOKEN), tokenSourceTypeValidatorBuilder);
        rootSources.put(new SourceTypeIdKey(SourceType.OAUTH_PERSISTENT_GRANT), new PersistentGrantSourceTypeValidatorBuilder(null, "persistentgrant."));
        ExpressionManager expressionManager = ExpressionManager.getInstance();
        if (expressionManager.isEvaluateExpressionsOn()) {
            rootSources.put(new SourceTypeIdKey(SourceType.EXPRESSION), new ExpressionSourceTypeValidatorBuilder(this.getContext()));
        }
        AttributeMapping attributeMapping = policy.getAttributeMapping();
        HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>(rootSources);
        int index = 0;
        for (AttributeSource attributeSource : policy.getAttributeMapping().getAttributeSources()) {
            this.addValidator((Validator)new NotBlankValidator(attributeSource.getId(), "Attribute Source ID", OpenIdConnectPolicyPaths.getAttributeSourceId(index)));
            ++index;
        }
        this.mapDataStoreTypesToDsValidators(attributeMapping, validSources);
        this.addValidator((Validator)new AttributeMappingValidator(attributeMapping, this.getAllAttributeNames(policy), tokenSourceTypeValidatorBuilder.getExposedSubstitutionVariables(), "access token", validSources, OpenIdConnectPolicyPaths.getAttributeMapping(), this.getContext()));
    }

    private ContextSourceTypeValidatorBuilder createContextTypeBuilder() {
        ContextSourceTypeValidatorBuilder builder = new ContextSourceTypeValidatorBuilder();
        builder.setContextSources(SourceContextType.getContextTypesForOpenIdPolicy());
        return builder;
    }

    private TextSourceTypeValidatorBuilder createTextValBuilder() {
        TextSourceTypeValidatorBuilder textValBuilder = new TextSourceTypeValidatorBuilder();
        textValBuilder.setAcceptBlankValues(false);
        return textValBuilder;
    }

    private TokenSourceTypeValidatorBuilder createTokenTypeBuilder(String tokenManagerId) {
        BearerAccessTokenMgmtPluginManager accessTokenMgmtPluginMgr = MgmtFactory.getBearerAccessTokenMgmtPluginMgr();
        ConfigurablePluginInstance instance = accessTokenMgmtPluginMgr.getInstance(tokenManagerId);
        HashSet<String> srcNames = new HashSet<String>();
        if (instance != null) {
            srcNames.addAll(instance.getAttributeContract().getMutableAttributeNames());
        }
        return new TokenSourceTypeValidatorBuilder(srcNames);
    }

    private Set<String> getAllAttributeNames(OpenIdConnectPolicy policy) {
        HashSet<String> allAttributes = new HashSet<String>();
        allAttributes.addAll(this.getCoreAttributeNames());
        allAttributes.addAll(this.getExtendedAttributeNames(policy));
        return allAttributes;
    }

    private Set<String> getCoreAttributeNames() {
        return new UserInfoAttrContract().getImmutableAttributeNames();
    }

    private Set<String> getExtendedAttributeNames(OpenIdConnectPolicy policy) {
        HashSet<String> extendedAttributeNames = new HashSet<String>();
        for (OpenIdConnectAttribute attribute : policy.getAttributeContract().getExtendedAttributes()) {
            extendedAttributeNames.add(attribute.getName());
        }
        return extendedAttributeNames;
    }
}

