/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.ParameterValues;
import com.pingidentity.admin.api.model.fieldpaths.oauth.OpenIdConnectPolicyPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sourceid.oauth20.domain.ScopeManager;
import org.sourceid.openid.connect.OpenIdParamNames;
import org.sourceid.openid.connect.domain.UserInfoClaims;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class OpenIdConnectPolicyScopeAttributeValidator
extends AbstractValidator {
    private final Set<String> allAttributes;
    private ScopeManager scopeManager = MgmtFactory.getScopeManager();
    private final Map<String, ParameterValues> scopeAttributeMappings;
    private static final Map<String, List<String>> localScopesEnabledMap = new HashMap<String, List<String>>(){
        {
            this.put("email", Arrays.asList("email", "email_verified"));
            this.put("address", UserInfoClaims.ADDRESS_CLAIMS);
            this.put("phone", Arrays.asList("phone_number", "phone_number_verified"));
            this.put("profile", UserInfoClaims.PROFILE_CLAIMS);
            this.put("openid", OpenIdParamNames.OPENID_IDTOKEN_STANDARD_CLAIMS);
        }
    };
    public static final Map<String, List<String>> scopesEnabledMap = Collections.unmodifiableMap(localScopesEnabledMap);

    public OpenIdConnectPolicyScopeAttributeValidator(Map<String, ParameterValues> scopeAttributeMappings, Set<String> attributes) {
        this.scopeAttributeMappings = scopeAttributeMappings;
        this.allAttributes = attributes;
    }

    public boolean validate() {
        HashMap<String, String> allScopes = new HashMap<String, String>();
        allScopes.putAll(this.retrieveScopeDescriptions());
        allScopes.putAll(this.retrieveExclusiveScopeDescriptions());
        for (Map.Entry<String, ParameterValues> entry : this.scopeAttributeMappings.entrySet()) {
            String scopeName = entry.getKey();
            if (!allScopes.containsKey(scopeName)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_policy_attribute_scope_name_invalid, OpenIdConnectPolicyPaths.getScopeAttributeMappings(), new Object[]{scopeName}));
            }
            if (entry.getValue() == null || entry.getValue().getValues() == null || entry.getValue().getValues().size() == 0) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_policy_attribute_value_required, OpenIdConnectPolicyPaths.getScopeAttributeMappings(), new Object[]{scopeName}));
                continue;
            }
            List notValidAttributes = entry.getValue().getValues().stream().filter(name -> !this.allAttributes.contains(name)).collect(Collectors.toList());
            if (notValidAttributes.size() > 0) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_policy_scope_attribute_name_invalid, OpenIdConnectPolicyPaths.getScopeAttributeMappings(), new Object[]{scopeName, notValidAttributes.stream().map(s -> "'" + s + "'").collect(Collectors.joining(", "))}));
            }
            if (scopesEnabledMap.containsKey(scopeName) && !entry.getValue().getValues().containsAll((Collection)scopesEnabledMap.get(scopeName))) {
                ArrayList<String> attributes = new ArrayList<String>(entry.getValue().getValues());
                List<Object> mustHaveAttributes = new ArrayList(scopesEnabledMap.get(scopeName));
                mustHaveAttributes.removeAll(attributes);
                if (scopeName.equalsIgnoreCase("openid")) {
                    mustHaveAttributes.retainAll(this.allAttributes);
                }
                if (!(mustHaveAttributes = mustHaveAttributes.stream().filter(attr -> this.allAttributes.contains(attr)).collect(Collectors.toList())).isEmpty()) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_policy_attribute_scope_must_contain_attributes, OpenIdConnectPolicyPaths.getScopeAttributeMappings(), new Object[]{scopeName, mustHaveAttributes.stream().map(s -> "'" + s + "'").collect(Collectors.joining(", "))}));
                }
            }
            HashMap<String, Boolean> uniqueValue = new HashMap<String, Boolean>();
            for (String value : entry.getValue().getValues()) {
                if (uniqueValue.keySet().contains(value)) {
                    if (((Boolean)uniqueValue.get(value)).booleanValue()) continue;
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_policy_attribute_value_duplicate_entry, OpenIdConnectPolicyPaths.getScopeAttributeMappings(), new Object[]{scopeName, value}));
                    uniqueValue.put(value, Boolean.TRUE);
                    continue;
                }
                uniqueValue.put(value, Boolean.FALSE);
            }
        }
        return false;
    }

    private Map<String, String> retrieveScopeDescriptions() {
        return this.scopeManager.getScopeDescriptions();
    }

    private Map<String, String> retrieveExclusiveScopeDescriptions() {
        return this.scopeManager.getExclusiveScopeDescriptions();
    }
}

