/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.fieldpaths.oauth.OpenIdConnectSettingsPaths;
import com.pingidentity.admin.api.model.oauth.OIDCSessionSettings;
import com.pingidentity.admin.api.model.oauth.OpenIdConnectSettings;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.ResourceIdValidator;
import com.pingidentity.admin.api.validator.SessionRevocationLifetimeValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;

public class OpenIdConnectSettingsValidator
extends CompositeValidator {
    private final OpenIdConnectSettings settings;
    private final OpenIdConnectProviderPolicy policy;

    public OpenIdConnectSettingsValidator(OpenIdConnectSettings settings, OpenIdConnectProviderPolicy policy) {
        OIDCSessionSettings sessionSettings;
        this.settings = settings;
        this.policy = policy;
        if (settings.getDefaultPolicyRef() != null) {
            this.addValidator((Validator)new ResourceIdValidator(settings.getDefaultPolicyRef(), "Default policy reference", OpenIdConnectSettingsPaths.getDefaultPolicyRef()));
        }
        if (settings.getSessionSettings() == null) {
            settings.setSessionSettings(new OIDCSessionSettings());
        }
        if ((sessionSettings = settings.getSessionSettings()).getSessionRevocationLifetime() == null) {
            sessionSettings.setSessionRevocationLifetime(1450);
        }
        this.addValidator((Validator)new SessionRevocationLifetimeValidator(sessionSettings.getSessionRevocationLifetime().toString(), OpenIdConnectSettingsPaths.getSessionRevocationLifetime()));
    }

    @Override
    public boolean validate() {
        super.validate();
        ResourceLink defaultPolicyRef = this.settings.getDefaultPolicyRef();
        if (defaultPolicyRef != null) {
            if (!this.policy.containsPolicyGroup(defaultPolicyRef.getId())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_default_policy_id_invalid, OpenIdConnectSettingsPaths.getDefaultPolicyRef(), new Object[]{defaultPolicyRef.getId()}));
            }
        } else if (!this.policy.getPolicyGroups().isEmpty()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_default_policy_required, OpenIdConnectSettingsPaths.getDefaultPolicyRef()));
        }
        return !this.hasErrors();
    }
}

