/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.OIDCLoginType;
import com.pingidentity.admin.api.model.OIDCProviderSettings;
import com.pingidentity.admin.api.model.OIDCRequestParameter;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.model.fieldpaths.OpenIdConnectMetadataPaths;
import com.pingidentity.admin.api.validator.AttributeFulfillmentValueValidator;
import com.pingidentity.admin.api.validator.AttributeMappingValidator;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.ContextSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ExpressionSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ExtendedMetadataSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.NoMappingTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.OpenIdRequestParamValidator;
import com.pingidentity.admin.api.validator.OpenIdRequestParamsValidator;
import com.pingidentity.admin.api.validator.PartnerUrlValidatorFactory;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.TextSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.TrackedParametersSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.pf.admin.rest.translator.OIDCProviderTranslator;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.ValidationUtil;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.OIDCAuthScheme;
import org.sourceid.saml20.domain.OIDCProfile;
import org.sourceid.saml20.domain.OIDCRequestParamSetting;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class OpenIdMetadataValidator
extends CompositeValidator {
    private static final int MAX_LIFETIME = 1440;
    private static final ExpressionManager expressionManager = ExpressionManager.getInstance();
    private final String authorizationEndpoint;
    private final String tokenEndpoint;
    private final String userinfoEndpoint;
    private final boolean trackUserSessionsForLogout;
    private final String logoutEndpoint;
    private final String jwksUrl;
    private final String scopes;
    private final OIDCProfile profile;
    private final boolean isBaseUrlConfigured;
    private final List<OIDCRequestParamSetting> requestParams;
    private final OIDCAuthScheme authScheme;
    private final String lifetime;
    private final String signingAlgorithm;
    private final String requestObjectSigningAlgorithm;
    private final boolean requestObjectSigningSelected;
    private final boolean enablePkce;
    private final ValidatorContext context;
    private final String pushedAuthorizationEndpoint;

    public OpenIdMetadataValidator(String authorizationEndpoint, String pushedAuthorizationEndpoint, String tokenEndpoint, String userinfoEndpoint, boolean trackUserSessionsForLogout, String logoutEndpoint, String jwksUrl, String scopes, OIDCProfile profile, OIDCAuthScheme authScheme, String lifetime, String signingAlgorithm, boolean requestObjectSigningSelected, String requestObjectSigningAlgorithm, boolean isBaseUrlConfigured, List<OIDCRequestParamSetting> reqParams, ValidatorContext context) {
        this.authorizationEndpoint = authorizationEndpoint;
        this.tokenEndpoint = tokenEndpoint;
        this.userinfoEndpoint = userinfoEndpoint;
        this.trackUserSessionsForLogout = trackUserSessionsForLogout;
        this.logoutEndpoint = logoutEndpoint;
        this.jwksUrl = jwksUrl;
        this.scopes = scopes;
        this.profile = profile;
        this.authScheme = authScheme;
        this.lifetime = lifetime;
        this.signingAlgorithm = signingAlgorithm;
        this.requestObjectSigningSelected = requestObjectSigningSelected;
        this.requestObjectSigningAlgorithm = requestObjectSigningAlgorithm;
        this.isBaseUrlConfigured = isBaseUrlConfigured;
        this.requestParams = reqParams;
        this.enablePkce = false;
        this.context = context;
        this.pushedAuthorizationEndpoint = pushedAuthorizationEndpoint;
        this.addURLValidators(authorizationEndpoint, tokenEndpoint, userinfoEndpoint, jwksUrl, pushedAuthorizationEndpoint, logoutEndpoint, isBaseUrlConfigured, false, null);
    }

    public OpenIdMetadataValidator(OIDCProviderSettings apiProviderSettings, boolean isBaseUrlConfigured, ValidatorContext context) {
        List<OIDCRequestParameter> apiReqParams = apiProviderSettings.getRequestParameters();
        OIDCLoginType loginType = apiProviderSettings.getLoginType();
        OIDCProfile oidcProfile = null;
        if (loginType != null) {
            oidcProfile = loginType.getOIDCProfile();
        }
        ArrayList<OIDCRequestParamSetting> reqParamsList = new ArrayList<OIDCRequestParamSetting>();
        if (apiReqParams != null) {
            for (OIDCRequestParameter oidcReqParam : apiReqParams) {
                AttrMappingValue domainValue;
                AttributeFulfillmentValue apiValue = oidcReqParam.getAttributeValue();
                if (apiValue == null) {
                    org.sourceid.saml20.domain.SourceType sourceType = org.sourceid.saml20.domain.SourceType.TEXT;
                    if (StringUtils.isEmpty((String)oidcReqParam.getValue())) {
                        sourceType = org.sourceid.saml20.domain.SourceType.NO_MAPPING;
                    }
                    domainValue = new AttrMappingValue(sourceType, oidcReqParam.getValue());
                } else {
                    domainValue = OIDCProviderTranslator.apiToDomainRequestParamMappingValue(oidcReqParam, false);
                }
                OIDCRequestParamSetting param = new OIDCRequestParamSetting(oidcReqParam.getName(), domainValue, Boolean.valueOf(oidcReqParam.isApplicationEndpointOverride()));
                reqParamsList.add(param);
            }
        }
        this.authorizationEndpoint = apiProviderSettings.getAuthorizationEndpoint();
        this.tokenEndpoint = apiProviderSettings.getTokenEndpoint();
        this.userinfoEndpoint = apiProviderSettings.getUserInfoEndpoint();
        this.trackUserSessionsForLogout = apiProviderSettings.isTrackUserSessionsForLogout();
        this.logoutEndpoint = apiProviderSettings.getLogoutEndpoint();
        this.jwksUrl = apiProviderSettings.getJwksURL();
        this.scopes = apiProviderSettings.getScopes();
        this.profile = oidcProfile;
        this.authScheme = apiProviderSettings.getAuthenticationScheme() != null ? OIDCAuthScheme.valueOf((String)apiProviderSettings.getAuthenticationScheme().toString()) : null;
        this.lifetime = apiProviderSettings.getLifetime();
        this.signingAlgorithm = apiProviderSettings.getAuthenticationSigningAlgorithm() != null ? apiProviderSettings.getAuthenticationSigningAlgorithm().getId() : null;
        this.requestObjectSigningSelected = apiProviderSettings.getRequestSigningAlgorithm() != null;
        this.requestObjectSigningAlgorithm = apiProviderSettings.getRequestSigningAlgorithm() != null ? apiProviderSettings.getRequestSigningAlgorithm().getId() : null;
        this.isBaseUrlConfigured = isBaseUrlConfigured;
        this.requestParams = reqParamsList;
        this.enablePkce = apiProviderSettings.getEnablePKCE();
        this.context = context;
        this.pushedAuthorizationEndpoint = apiProviderSettings.getPushedAuthorizationRequestEndpoint();
        this.addURLValidators(this.authorizationEndpoint, this.tokenEndpoint, this.userinfoEndpoint, this.jwksUrl, this.pushedAuthorizationEndpoint, this.logoutEndpoint, isBaseUrlConfigured, true, apiReqParams);
    }

    private Set<SourceType> getSourceTypes() {
        HashSet<SourceType> validSourceTypes = new HashSet<SourceType>();
        validSourceTypes.add(SourceType.CONTEXT);
        if (expressionManager.isEvaluateExpressionsOn()) {
            validSourceTypes.add(SourceType.EXPRESSION);
        }
        validSourceTypes.add(SourceType.NO_MAPPING);
        validSourceTypes.add(SourceType.EXTENDED_PROPERTIES);
        validSourceTypes.add(SourceType.TEXT);
        validSourceTypes.add(SourceType.TRACKED_HTTP_PARAMS);
        return validSourceTypes;
    }

    private void addURLValidators(String authorizationEndpoint, String tokenEndpoint, String userinfoEndpoint, String jwksUrl, String pushedAuthorizationEndpoint, String logoutEndpoint, boolean isBaseUrlConfigured, boolean validateReqParamEntry, List<OIDCRequestParameter> apiRequestParams) {
        List<String> urls = Arrays.asList(authorizationEndpoint, tokenEndpoint, userinfoEndpoint, jwksUrl, pushedAuthorizationEndpoint, logoutEndpoint);
        for (String url : urls) {
            if (!StringUtils.isNotBlank((String)url)) continue;
            this.addValidator((Validator)PartnerUrlValidatorFactory.getGenericValidator(url, isBaseUrlConfigured, null));
        }
        if (apiRequestParams != null) {
            this.addValidator((Validator)new OpenIdRequestParamsValidator(apiRequestParams));
        }
        this.addValidator((Validator)new OpenIdRequestParamValidator(this.requestParams, validateReqParamEntry));
    }

    @Override
    public boolean validate() {
        super.validate();
        if (this.hasErrors()) {
            return false;
        }
        if (StringUtils.isBlank((String)this.scopes)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_required, OpenIdConnectMetadataPaths.getScopes(), new Object[]{"Scopes"}));
        } else {
            boolean openIdScopeExists = Arrays.asList(this.scopes.split(" ")).stream().map(String::trim).filter(scope -> scope.equalsIgnoreCase("openId")).findAny().isPresent();
            if (!openIdScopeExists) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_required, OpenIdConnectMetadataPaths.getScopes(), new Object[]{"'openid' scope of the 'Scopes'"}));
            }
        }
        if (StringUtils.isBlank((String)this.authorizationEndpoint)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_required, OpenIdConnectMetadataPaths.getAuthEndpoint(), new Object[]{"Authorization Endpoint"}));
        } else if (!this.isBaseUrlConfigured && !ValidationUtil.isValidHttpsUrl((String)this.authorizationEndpoint)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.malformed_https_url, OpenIdConnectMetadataPaths.getAuthEndpoint(), new Object[]{this.authorizationEndpoint}));
        }
        if (this.profile == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_required, OpenIdConnectMetadataPaths.getLoginType(), new Object[]{OpenIdConnectMetadataPaths.getLoginType()}));
        } else if (this.profile == OIDCProfile.BASIC) {
            if (StringUtils.isBlank((String)this.tokenEndpoint)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_required, OpenIdConnectMetadataPaths.getTokenEndpoint(), new Object[]{"Token Endpoint"}));
            } else if (!this.isBaseUrlConfigured && !ValidationUtil.isValidHttpsUrl((String)this.tokenEndpoint)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.malformed_https_url, OpenIdConnectMetadataPaths.getTokenEndpoint(), new Object[]{this.tokenEndpoint}));
            }
            if (this.authScheme == OIDCAuthScheme.PRIVATE_KEY_JWT || this.authScheme == OIDCAuthScheme.CLIENT_SECRET_JWT) {
                if (null != this.lifetime && !this.lifetime.isEmpty()) {
                    try {
                        int lifetimeValue = Integer.parseInt(this.lifetime);
                        if (lifetimeValue <= 0 || lifetimeValue > 1440) {
                            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_lifetime_invalid, OpenIdConnectMetadataPaths.getLifetimePath(), new Object[]{"Lifetime"}));
                        }
                    }
                    catch (NumberFormatException e) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.integer_value_invalid, OpenIdConnectMetadataPaths.getLifetimePath(), new Object[]{"Lifetime"}));
                    }
                }
                if (StringUtils.isEmpty((String)this.signingAlgorithm)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_authentication_signing_algorithm_required, OpenIdConnectMetadataPaths.getSigningAlgorithm(), new Object[]{"Authentication Signing Algorithm"}));
                }
            }
        } else if (this.enablePkce) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_cannot_enable_pkce, OpenIdConnectMetadataPaths.getEnablePKCEPath(), new Object[]{this.profile}));
        }
        if (this.requestObjectSigningSelected && StringUtils.isEmpty((String)this.requestObjectSigningAlgorithm)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_request_object_signing_algorithm_required, OpenIdConnectMetadataPaths.getRequestObjectSigningAlgorithm(), new Object[]{"Request Signing Algorithm"}));
        }
        if (StringUtils.isNotBlank((String)this.userinfoEndpoint) && !this.isBaseUrlConfigured && !ValidationUtil.isValidHttpsUrl((String)this.userinfoEndpoint)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.malformed_https_url, OpenIdConnectMetadataPaths.getUserInfoEndpoint(), new Object[]{"User Info Endpoint"}));
        }
        if (StringUtils.isBlank((String)this.jwksUrl)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_required, OpenIdConnectMetadataPaths.getJwksURL(), new Object[]{"JWKS URL"}));
        } else if (!this.isBaseUrlConfigured && !ValidationUtil.isValidHttpsUrl((String)this.jwksUrl)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.malformed_https_url, OpenIdConnectMetadataPaths.getJwksURL(), new Object[]{this.jwksUrl}));
        }
        if (!this.trackUserSessionsForLogout && StringUtils.isNotBlank((String)this.logoutEndpoint)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_track_user_sessions_for_logout_not_enabled, OpenIdConnectMetadataPaths.getTrackUserSessionsForLogout()));
        }
        this.validateReqParams();
        return !this.hasErrors();
    }

    private TextSourceTypeValidatorBuilder createTextValBuilder() {
        TextSourceTypeValidatorBuilder textValBuilder = new TextSourceTypeValidatorBuilder();
        textValBuilder.setAcceptBlankValues(false);
        return textValBuilder;
    }

    private void validateReqParams() {
        if (this.requestParams == null || this.requestParams.isEmpty()) {
            return;
        }
        Set<SourceType> validSourceTypes = this.getSourceTypes();
        HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> validSourcesTypeBuilders = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>();
        validSourcesTypeBuilders.put(new SourceTypeIdKey(SourceType.TEXT), this.createTextValBuilder());
        if (expressionManager.isEvaluateExpressionsOn()) {
            validSourcesTypeBuilders.put(new SourceTypeIdKey(SourceType.EXPRESSION), new ExpressionSourceTypeValidatorBuilder(this.context));
        }
        HashSet<String> substitutionVars = new HashSet<String>();
        List trackedParams = MgmtFactory.getTrackedHttpParamManager().getTrackedParamSettings().getTrackedParamNames();
        if (trackedParams != null && !trackedParams.isEmpty()) {
            TrackedParametersSourceTypeValidatorBuilder trackedParamsValidator = new TrackedParametersSourceTypeValidatorBuilder(trackedParams);
            validSourcesTypeBuilders.put(new SourceTypeIdKey(SourceType.TRACKED_HTTP_PARAMS, "trackedparams"), trackedParamsValidator);
            substitutionVars.addAll(trackedParamsValidator.getExposedSubstitutionVariables());
        }
        ContextSourceTypeValidatorBuilder cstb = new ContextSourceTypeValidatorBuilder();
        cstb.setContextSources(SourceContextType.getContextTypesForOIDCRequestParams());
        validSourcesTypeBuilders.put(new SourceTypeIdKey(SourceType.CONTEXT), cstb);
        ExtendedMetadataSourceTypeValidatorBuilder extPropertiValidatorBuilder = new ExtendedMetadataSourceTypeValidatorBuilder(SourceType.EXTENDED_PROPERTIES);
        validSourcesTypeBuilders.put(new SourceTypeIdKey(SourceType.EXTENDED_PROPERTIES), extPropertiValidatorBuilder);
        NoMappingTypeValidatorBuilder noMappingTypeValidatorBuilder = new NoMappingTypeValidatorBuilder();
        validSourcesTypeBuilders.put(new SourceTypeIdKey(SourceType.NO_MAPPING), noMappingTypeValidatorBuilder);
        substitutionVars.addAll(cstb.getExposedSubstitutionVariables());
        substitutionVars.addAll(extPropertiValidatorBuilder.getExposedSubstitutionVariables());
        AttributeMappingValidator.populateSourceTypeBuilderSubstitutionValue(substitutionVars, validSourcesTypeBuilders);
        for (int i = 0; i < this.requestParams.size(); ++i) {
            OIDCRequestParamSetting param = this.requestParams.get(i);
            AttrMappingValue attrMappingValue = param.getValue();
            if (attrMappingValue == null) continue;
            AttributeFulfillmentValue apiAttrMappingValue = new AttributeFulfillmentValue();
            apiAttrMappingValue.setSource(new SourceTypeIdKey(SourceType.getApiSourceTypeFromDomainSourceType(attrMappingValue.getType()), attrMappingValue.getAttributeSourceId()));
            apiAttrMappingValue.setValue(attrMappingValue.getValue());
            AttributeFulfillmentValueValidator attributeMappingValidator = new AttributeFulfillmentValueValidator(validSourceTypes, validSourcesTypeBuilders, this.context, OpenIdConnectMetadataPaths.getRequestParameters(i), param.getName(), apiAttrMappingValue);
            attributeMappingValidator.validate();
            if (!attributeMappingValidator.hasErrors()) continue;
            this.appendErrors(attributeMappingValidator.getErrors());
        }
    }
}

