/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.OpenIdConnectMetadataPaths;
import com.pingidentity.admin.api.validator.OpenIdRequestParamEntryValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.OIDCRequestParamSetting;

public class OpenIdRequestParamValidator
extends AbstractValidator {
    List<OIDCRequestParamSetting> existingReqParams = null;
    boolean validateEntry = false;

    public OpenIdRequestParamValidator(List<OIDCRequestParamSetting> existingParams) {
        this.existingReqParams = existingParams;
    }

    public OpenIdRequestParamValidator(List<OIDCRequestParamSetting> existingParams, boolean validateEntry) {
        this.existingReqParams = existingParams;
        this.validateEntry = validateEntry;
    }

    public boolean validate() {
        for (int i = 0; i < this.existingReqParams.size(); ++i) {
            OIDCRequestParamSetting param = this.existingReqParams.get(i);
            AttrMappingValue paramMappingValue = param.getValue();
            if (this.validateEntry) {
                OpenIdRequestParamEntryValidator entryValidator = new OpenIdRequestParamEntryValidator(param.getName(), paramMappingValue == null ? null : paramMappingValue.getValue(), param.isOverride(), paramMappingValue == null ? null : paramMappingValue.getType(), i);
                entryValidator.validate();
                this.appendErrors(entryValidator.getErrors());
            }
            for (int j = i + 1; j < this.existingReqParams.size(); ++j) {
                OIDCRequestParamSetting other = this.existingReqParams.get(j);
                if (other.getName() == null) continue;
                if (param.equals((Object)other)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_duplicate_entry, OpenIdConnectMetadataPaths.getRequestParameters(i), new Object[]{param.getName()}));
                }
                if (other.getName().equals(param.getName()) && other.isOverride() != param.isOverride()) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_multivalued_param_inconsistent_override, OpenIdConnectMetadataPaths.getRequestParameters(i), new Object[]{param.getName()}));
                }
                if (!other.getName().equals(param.getName()) || param.getValue() == null || other.getValue() == null || !StringUtils.isNotEmpty((String)param.getValue().getValue()) || !StringUtils.isEmpty((String)other.getValue().getValue())) continue;
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_param_whitelisted, OpenIdConnectMetadataPaths.getRequestParameters(i), new Object[]{param.getName()}));
            }
        }
        return !this.hasErrors();
    }
}

