/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.ArtifactResolverLocation;
import com.pingidentity.admin.api.model.ArtifactSettings;
import com.pingidentity.admin.api.model.Connection;
import com.pingidentity.admin.api.model.IdpAttributeQuery;
import com.pingidentity.admin.api.model.IdpConnection;
import com.pingidentity.admin.api.model.OutboundBackChannelAuth;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.InboundBackChannelAuthTypeValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.metadata.Role;

public class OutboundBackChannelAuthTypeValidator
extends InboundBackChannelAuthTypeValidator {
    protected final boolean sslDisabled;
    protected final boolean attributeQuery;
    protected final boolean xaspEndpointHttps;
    protected final Role role;

    public OutboundBackChannelAuthTypeValidator(Connection connection) {
        super(connection.getCredentials().getOutboundBackChannelAuth().getSslAuthKeyPairRef() != null, connection.getCredentials().getOutboundBackChannelAuth().getHttpBasicCredentials() != null, OutboundBackChannelAuthTypeValidator.isDigitalSignatureOrAttributeQueryOnly(connection), OutboundBackChannelAuthTypeValidator.needAtLeastBasicOrCert(connection), ConnectionPaths.getOutboundBackChannelAuth());
        this.sslDisabled = this.anyEndpointNotUsingHttps(connection);
        this.role = connection.getType().getRole();
        this.attributeQuery = OutboundBackChannelAuthTypeValidator.isAttributeQuery(connection);
        this.xaspEndpointHttps = OutboundBackChannelAuthTypeValidator.xaspEndpointHttps(connection);
    }

    private static boolean isDigitalSignatureOrAttributeQueryOnly(Connection connection) {
        OutboundBackChannelAuth obBackChannelAuth;
        if (connection.getBrowserSso() == null && OutboundBackChannelAuthTypeValidator.getIdpAttributeQuery(connection) != null && (obBackChannelAuth = connection.getCredentials().getOutboundBackChannelAuth()).getHttpBasicCredentials() == null && obBackChannelAuth.getSslAuthKeyPairRef() == null) {
            return true;
        }
        return connection.getCredentials().getOutboundBackChannelAuth().isDigitalSignature();
    }

    private static IdpAttributeQuery getIdpAttributeQuery(Connection connection) {
        Role role = connection.getType().getRole();
        if (Role.IDP == role) {
            return ((IdpConnection)connection).getAttributeQuery();
        }
        return null;
    }

    private static boolean isAttributeQuery(Connection connection) {
        return OutboundBackChannelAuthTypeValidator.getIdpAttributeQuery(connection) != null;
    }

    private static boolean needAtLeastBasicOrCert(Connection connection) {
        return connection.getBrowserSso() != null && Protocol.isSaml1x(connection.getBrowserSso().getProtocol());
    }

    private static boolean xaspEndpointHttps(Connection connection) {
        if (OutboundBackChannelAuthTypeValidator.isAttributeQuery(connection)) {
            IdpAttributeQuery attributeQuery = OutboundBackChannelAuthTypeValidator.getIdpAttributeQuery(connection);
            String endpointLocation = attributeQuery.getUrl();
            if (endpointLocation != null && endpointLocation.toLowerCase().startsWith("http")) {
                if (endpointLocation.toLowerCase().startsWith("https")) {
                    return true;
                }
            } else {
                return OutboundBackChannelAuthTypeValidator.isBaseUrlHttps(connection.getBaseUrl());
            }
        }
        return false;
    }

    private static boolean isBaseUrlHttps(String baseUrl) {
        return baseUrl != null && StringUtils.defaultString((String)baseUrl).toLowerCase().startsWith("https");
    }

    public OutboundBackChannelAuthTypeValidator(boolean cert, boolean basic, boolean none, boolean needAtLeastBasicOrCert, boolean sslDisabled, boolean attributeQuery, boolean xaspEndpointHttps, Role role) {
        super(cert, basic, none, needAtLeastBasicOrCert, ConnectionPaths.getOutboundBackChannelAuth());
        this.sslDisabled = sslDisabled;
        this.attributeQuery = attributeQuery;
        this.xaspEndpointHttps = xaspEndpointHttps;
        this.role = role;
    }

    @Override
    public boolean validate() {
        super.validate();
        if ((this.sslDisabled || Role.IDP == this.role && this.attributeQuery && !this.xaspEndpointHttps) && !this.basic && !this.none) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.backchannelauth_cert_or_none_required, ConnectionPaths.getOutboundBackChannelAuth()));
        }
        return !this.hasErrors();
    }

    private boolean anyEndpointNotUsingHttps(Connection connection) {
        if (connection.getBrowserSso() == null || connection.getBrowserSso() != null && connection.getBrowserSso().getArtifact() == null) {
            return false;
        }
        ArtifactSettings artifact = connection.getBrowserSso().getArtifact();
        for (ArtifactResolverLocation item : artifact.getResolverLocations()) {
            String itemURL;
            if (!StringUtils.isNotBlank((String)item.getUrl()) || (itemURL = item.getUrl().toLowerCase()).startsWith("https")) continue;
            if (connection.getBaseUrl() != null) {
                if (StringUtils.defaultString((String)connection.getBaseUrl()).toLowerCase().startsWith("https")) continue;
                return true;
            }
            return true;
        }
        return false;
    }
}

