/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.OutboundProvisionDatabase;
import com.pingidentity.admin.api.model.fieldpaths.ServerSettingsPaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.NotNullValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerConfig;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.CustomDataSource;
import org.sourceid.saml20.domain.mgmt.LocalSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.Role;

public class OutboundProvisionDatabaseValidator
extends CompositeValidator {
    private OutboundProvisionDatabase outboundProvisionDatabase;
    private static final LocalSettingsManager LOCAL_SETTINGS_MGR = MgmtFactory.getLocalSettingsManager();
    private ValidationErrorFactory factory = ValidationErrorFactory.getInstance();

    public OutboundProvisionDatabaseValidator(OutboundProvisionDatabase outboundProvisionDatabase) {
        this.outboundProvisionDatabase = outboundProvisionDatabase;
        this.addValidator((Validator)new NotNullValidator(outboundProvisionDatabase.getSynchronizationFrequency(), ServerSettingsPaths.OutboundProvisionDatabasePaths.getSynchronizationFrequency(), ServerSettingsPaths.OutboundProvisionDatabasePaths.getSynchronizationFrequency()));
    }

    @Override
    public boolean validate() {
        if (!LOCAL_SETTINGS_MGR.getLocalSettings().isEnableOutboundProvisioning()) {
            this.appendError(this.factory.create(ApiMessageKey.outbound_provisioning_not_enabled, ServerSettingsPaths.RolesAndProtocolsPaths.getEnableOutboundProvisioing(Role.IDP)));
            return false;
        }
        if (this.outboundProvisionDatabase.getDataStoreRef() == null || StringUtils.isEmpty((String)this.outboundProvisionDatabase.getDataStoreRef().getId())) {
            this.verifyNoOutboundProvConnectionsExist();
        } else {
            CustomDataSource dataSource;
            String dataStoreId = this.outboundProvisionDatabase.getDataStoreRef().getId();
            Object object = dataSource = MgmtFactory.getDataSourceManager().getJdbcDataSource(dataStoreId) == null ? MgmtFactory.getDataSourceManager().getCustomDataSource(dataStoreId) : MgmtFactory.getDataSourceManager().getJdbcDataSource(dataStoreId);
            if (dataSource == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.outbound_provisioning_invalid_jdbc_or_custom_datastore, ServerSettingsPaths.OutboundProvisionDatabasePaths.getDataStoreRefId()));
            }
        }
        if (this.outboundProvisionDatabase.getSynchronizationFrequency() < 1) {
            this.appendError(this.factory.create(ApiMessageKey.invalid_positive_integer, ServerSettingsPaths.OutboundProvisionDatabasePaths.getSynchronizationFrequency(), new Object[]{this.outboundProvisionDatabase.getSynchronizationFrequency()}));
        }
        return !this.hasErrors();
    }

    public void verifyNoOutboundProvConnectionsExist() {
        Collection allSpConnections = MgmtFactory.getConnectionManager().getAllSpConnections();
        for (ConnectionBase connection : allSpConnections) {
            ProvisionerConfig provisionerConfig;
            if (!connection.isActive() || (provisionerConfig = (ProvisionerConfig)connection.getModuleConfiguration(ProvisionerConfig.class)) == null) continue;
            this.appendError(this.factory.create(ApiMessageKey.outbound_provisioning_datastore_required, ServerSettingsPaths.OutboundProvisionDatabasePaths.getDataStoreRef(), new Object[]{ServerSettingsPaths.OutboundProvisionDatabasePaths.getDataStoreRef()}));
            break;
        }
    }
}

