/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import org.sourceid.common.ValidationUtil;

public class PartnerUrlValidator
extends AbstractValidator {
    private final ApiMessageKey malformedUrlMsgKey;
    private final ApiMessageKey malformedRelUrlMsgKey;
    private final ApiMessageKey noBaseUrlForRelPathMsgKey;
    private final String url;
    private final boolean isBaseUrlDefined;
    private final String fieldPath;
    private boolean skipHttpOrHttpsValidation;

    PartnerUrlValidator(ApiMessageKey malformedUrlMsgKey, ApiMessageKey malformedRelUrlMsgKey, ApiMessageKey noBaseUrlForRelPathMsgKey, String url, boolean isBaseUrlDefined, String fieldPath) {
        this.malformedUrlMsgKey = malformedUrlMsgKey;
        this.malformedRelUrlMsgKey = malformedRelUrlMsgKey;
        this.noBaseUrlForRelPathMsgKey = noBaseUrlForRelPathMsgKey;
        this.url = url;
        this.isBaseUrlDefined = isBaseUrlDefined;
        this.fieldPath = fieldPath;
    }

    PartnerUrlValidator(ApiMessageKey malformedUrlMsgKey, ApiMessageKey malformedRelUrlMsgKey, ApiMessageKey noBaseUrlForRelPathMsgKey, String url, boolean isBaseUrlDefined, String fieldPath, boolean skipHttpOrHttpsValidation) {
        this(malformedUrlMsgKey, malformedRelUrlMsgKey, noBaseUrlForRelPathMsgKey, url, isBaseUrlDefined, fieldPath);
        this.skipHttpOrHttpsValidation = skipHttpOrHttpsValidation;
    }

    public boolean validate() {
        boolean validUrl;
        boolean result = true;
        boolean bl = validUrl = ValidationUtil.isValidHttpOrHttpsUrl((String)this.url) || this.skipHttpOrHttpsValidation && ValidationUtil.isValidUrl((String)this.url);
        if (!validUrl) {
            if (this.isBaseUrlDefined) {
                if (!ValidationUtil.startsWithForwardSlash((String)this.url)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(this.malformedRelUrlMsgKey, this.fieldPath, new Object[]{this.url}));
                    result = false;
                }
            } else if (ValidationUtil.startsWithForwardSlash((String)this.url)) {
                this.appendError(ValidationErrorFactory.getInstance().create(this.noBaseUrlForRelPathMsgKey, this.fieldPath, new Object[]{this.url}));
                result = false;
            } else {
                this.appendError(ValidationErrorFactory.getInstance().create(this.malformedUrlMsgKey, this.fieldPath, new Object[]{this.url}));
                result = false;
            }
        }
        return result;
    }
}

