/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.pf.common.api.CommonApiMsgKey;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import org.sourceid.common.ValidationUtil;

public class PasswordValidator
extends AbstractValidator {
    private static final String DEFAULT_FIELD_PATH = "password";
    private static final String DEFAULT_FIELD_NAME = "Password";
    private final String password;
    private final String fieldPath;
    private final String fieldName;
    private final int minLength;

    public PasswordValidator(String password) {
        this(password, DEFAULT_FIELD_PATH, DEFAULT_FIELD_NAME);
    }

    public PasswordValidator(String password, int minLength) {
        this(password, DEFAULT_FIELD_PATH, DEFAULT_FIELD_NAME, minLength);
    }

    public PasswordValidator(String password, String fieldPath, String fieldName) {
        this(password, fieldPath, fieldName, Integer.MIN_VALUE);
    }

    private PasswordValidator(String password, String fieldPath, String fieldName, int minLength) {
        this.password = password;
        this.fieldPath = fieldPath;
        this.fieldName = fieldName;
        this.minLength = minLength;
    }

    public boolean validate() {
        StringBuilder error = new StringBuilder();
        boolean isPasswordValid = this.minLength == Integer.MIN_VALUE ? ValidationUtil.isPasswordValid((String)this.password, (StringBuilder)error, (String)this.fieldName) : ValidationUtil.isPasswordValid((String)this.password, (StringBuilder)error, (String)this.fieldName, (int)this.minLength);
        if (!isPasswordValid) {
            this.appendError(new ValidationError(CommonApiMsgKey.invalid_password.toString(), error.toString(), this.fieldPath));
        }
        return !this.hasErrors();
    }
}

