/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class PersistentGrantSourceTypeValidator
extends AbstractValidator {
    private final String attributeName;
    private final String value;
    private final String fieldPath;
    private final Set<String> validAttrNames;
    private final PersistentGrantSourceTypeMsgContext msgContext;

    public PersistentGrantSourceTypeValidator(String attributeName, String value, Set<String> validAttrNames, String fieldPath, PersistentGrantSourceTypeMsgContext msgContext) {
        this.attributeName = attributeName;
        this.value = value;
        this.validAttrNames = validAttrNames;
        this.fieldPath = fieldPath;
        this.msgContext = msgContext;
    }

    public boolean validate() {
        if (StringUtils.isBlank((String)this.value)) {
            this.appendError(ValidationErrorFactory.getInstance().create(this.msgContext.getUnknownValueKey(), this.fieldPath, new Object[]{this.value, this.attributeName}));
        } else if (!this.validAttrNames.contains(this.value)) {
            this.appendError(ValidationErrorFactory.getInstance().create(this.msgContext.getValueNotApplicableKey(), this.fieldPath, new Object[]{this.value, this.attributeName}));
        }
        return !this.hasErrors();
    }

    public static enum PersistentGrantSourceTypeMsgContext {
        ATTR_MAPPING(ApiMessageKey.mapping_source_type_persistent_grant_unknown_value, ApiMessageKey.mapping_source_type_persistent_grant_unknown_value),
        ISSUANCE_CRITERIA(ApiMessageKey.issuance_criteria_source_type_persistent_grant_unknown_value, ApiMessageKey.issuance_criteria_source_type_persistent_grant_value_not_applicable);

        private final ApiMessageKey unknownValueKey;
        private final ApiMessageKey valueNotApplicableKey;

        private PersistentGrantSourceTypeMsgContext(ApiMessageKey unknownValueKey, ApiMessageKey valueNotApplicableKey) {
            this.unknownValueKey = unknownValueKey;
            this.valueNotApplicableKey = valueNotApplicableKey;
        }

        public ApiMessageKey getUnknownValueKey() {
            return this.unknownValueKey;
        }

        public ApiMessageKey getValueNotApplicableKey() {
            return this.valueNotApplicableKey;
        }
    }
}

