/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.PingOneConnection;
import com.pingidentity.admin.api.model.fieldpaths.PingOneConnectionPaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.IdValidator;
import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import java.util.Map;
import java.util.stream.Collectors;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class PingOneConnectionValidator
extends CompositeValidator {
    private static final int MAX_NAME_LENGTH = 128;
    private ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private boolean isCreate;
    private String name;
    private String id;
    private String encryptedCredential;
    private String credential;
    private String pingOneConnectionId;

    public PingOneConnectionValidator(PingOneConnection connection, boolean isCreate) {
        this.id = connection.getId();
        this.name = connection.getName();
        this.isCreate = isCreate;
        this.encryptedCredential = connection.getEncryptedCredential();
        this.credential = connection.getCredential();
        this.pingOneConnectionId = connection.getPingOneConnectionId();
        if (isCreate) {
            this.addValidator((Validator)new IdValidator(this.id, true, false, 0, 33, PingOneConnectionPaths.getId()));
        }
        this.addValidator((Validator)new NotBlankValidator(this.name, "Name", PingOneConnectionPaths.getName()));
    }

    @Override
    public boolean validate() {
        super.validate();
        Map<String, String> idNamesMap = MgmtFactory.getPingOneConnectionsManager().getAllConnections().stream().collect(Collectors.toMap(org.sourceid.saml20.domain.PingOneConnection::getId, org.sourceid.saml20.domain.PingOneConnection::getName));
        if (this.isCreate) {
            if (idNamesMap.containsKey(this.id)) {
                this.appendError(this.errorFactory.create(ApiMessageKey.pingone_connection_duplicate_id, PingOneConnectionPaths.getId(), new Object[]{this.id}));
            }
            if (idNamesMap.containsValue(this.name)) {
                this.appendError(this.errorFactory.create(ApiMessageKey.pingone_connection_duplicate_name, PingOneConnectionPaths.getName(), new Object[]{this.name}));
            }
        } else {
            for (Map.Entry<String, String> entry : idNamesMap.entrySet()) {
                if (entry.getKey().equals(this.id) || !entry.getValue().equals(this.name)) continue;
                this.appendError(this.errorFactory.create(ApiMessageKey.pingone_connection_duplicate_name, PingOneConnectionPaths.getName(), new Object[]{this.name}));
            }
        }
        if (this.credential != null && this.encryptedCredential != null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.pingone_connection_encrypted_credential_not_expected, PingOneConnectionPaths.getCredential(), new Object[]{PingOneConnectionPaths.getCredential(), PingOneConnectionPaths.getEncryptedCredential()}));
        }
        if (this.credential == null && this.encryptedCredential == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.pingone_connection_credential_required, PingOneConnectionPaths.getCredential()));
        }
        if (this.name != null && (this.name.length() > 128 || this.name.contains("-"))) {
            this.appendError(this.errorFactory.create(ApiMessageKey.pingone_connection_invalid_name, PingOneConnectionPaths.getName(), new Object[]{128}));
        }
        return !this.hasErrors();
    }

    public boolean validateAfterJwtProcessed(String credentialPath) {
        if (this.isCreate) {
            MgmtFactory.getPingOneConnectionsManager().getAllConnections().forEach(pingOneConnection -> {
                if (pingOneConnection.getPingOneConnectionId().equals(this.pingOneConnectionId)) {
                    this.appendError(this.errorFactory.create(ApiMessageKey.pingone_connection_exists_for_pingone_connection_id, credentialPath, new Object[]{pingOneConnection.getName()}));
                }
            });
        } else {
            org.sourceid.saml20.domain.PingOneConnection existingConn = MgmtFactory.getPingOneConnectionsManager().getConnection(this.id);
            if (existingConn != null && !existingConn.getPingOneConnectionId().equals(this.pingOneConnectionId)) {
                this.appendError(this.errorFactory.create(ApiMessageKey.pingone_connection_different_pingone_connection_id, credentialPath));
            }
        }
        return this.validate();
    }
}

