/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.model.fieldpaths.PluginInstancePaths;
import com.pingidentity.admin.api.validator.PluginConfigConsistencyValidator;
import com.pingidentity.admin.api.validator.PluginFieldsValidator;
import com.pingidentity.admin.api.validator.PluginTablesValidator;
import com.pingidentity.common.util.ConfigurationUtil;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.PluginDescriptor;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.adapter.gui.event.PreRenderCallback;

public class PluginConfigValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(PluginConfigValidator.class);
    private final Configuration config;
    private final Configuration configForPluginProcessing;
    private final GuiConfigDescriptor configDescriptor;
    private final String fieldPath;
    private final Map<String, Integer> fieldIndices;
    private final Map<String, Integer> tableIndices;
    private ValidatorContext validatorContext = null;

    public PluginConfigValidator(Configuration newConfig, PluginDescriptor pluginDescriptor, String configFieldPath, Map<String, Integer> fieldIndices, Map<String, Integer> tableIndices) {
        this(newConfig, pluginDescriptor.getGuiConfigDescriptorBuilder().buildNewGuiDescriptor(), configFieldPath, fieldIndices, tableIndices);
    }

    public PluginConfigValidator(Configuration newConfig, PluginDescriptor pluginDescriptor, String configFieldPath, Map<String, Integer> fieldIndices, Map<String, Integer> tableIndices, ValidatorContext validatorContext) {
        this(newConfig, pluginDescriptor, configFieldPath, fieldIndices, tableIndices);
        this.validatorContext = validatorContext;
    }

    public PluginConfigValidator(Configuration newConfig, GuiConfigDescriptor configDescriptor, String configFieldPath, Map<String, Integer> fieldIndices, Map<String, Integer> tableIndices) {
        this.config = newConfig;
        this.configForPluginProcessing = ConfigurationUtil.prepareForPlugin((Configuration)this.config);
        this.configDescriptor = configDescriptor;
        this.fieldPath = configFieldPath;
        this.fieldIndices = fieldIndices;
        this.tableIndices = tableIndices;
    }

    public boolean validate() {
        if (!this.validateConfigurationComponents()) {
            return false;
        }
        return this.validateDomainConfiguration();
    }

    private boolean validateDomainConfiguration() {
        if (this.configDescriptor.getValidationChain() != null) {
            PluginConfigConsistencyValidator consistencyValidator = new PluginConfigConsistencyValidator(this.configDescriptor.getValidationChain(), this.configForPluginProcessing, this.fieldPath, this.validatorContext);
            consistencyValidator.validate();
            this.appendErrors(consistencyValidator.getErrors());
        }
        return !this.hasErrors();
    }

    private boolean validateConfigurationComponents() {
        PluginConfigValidator.executePreRenderCallbacks(this.configDescriptor.getPreRenderCallbackChain(), this.configDescriptor.getFields(), this.configDescriptor.getAdvancedFields(), this.configDescriptor.getTables(), this.configForPluginProcessing);
        PluginTablesValidator tablesValidator = new PluginTablesValidator(this.config.getTables(), this.configDescriptor.getTables(), this.config, this.fieldPath + "." + PluginInstancePaths.ConfigurationPaths.getTables(), this.tableIndices, this.validatorContext);
        tablesValidator.validate();
        this.appendErrors(tablesValidator.getErrors());
        PluginFieldsValidator fieldsValidator = new PluginFieldsValidator(this.config.getFields(), this.configDescriptor.getFields(), this.fieldPath + "." + PluginInstancePaths.ConfigurationPaths.getFields(), this.fieldIndices, this.validatorContext);
        fieldsValidator.validate();
        this.appendErrors(fieldsValidator.getErrors());
        PluginFieldsValidator advancedFieldsValidator = new PluginFieldsValidator(this.config.getAdvancedFields().getFields(), this.configDescriptor.getAdvancedFields(), this.fieldPath + "." + PluginInstancePaths.ConfigurationPaths.getFields(), this.fieldIndices, this.validatorContext);
        advancedFieldsValidator.validate();
        this.appendErrors(advancedFieldsValidator.getErrors());
        return !this.hasErrors();
    }

    public static void executePreRenderCallbacks(List<PreRenderCallback> preRenderCallbacks, List<FieldDescriptor> fieldDescriptors, List<FieldDescriptor> advancedFieldDescriptors, List<TableDescriptor> tableDescriptors, Configuration config) {
        for (PreRenderCallback callback : preRenderCallbacks) {
            try {
                callback.callback(fieldDescriptors, advancedFieldDescriptors, tableDescriptors, config);
            }
            catch (Exception e) {
                String msg = "Unexpected exception thrown from plugin's pre-render callback.";
                log.error((Object)msg, (Throwable)e);
            }
        }
    }
}

