/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.mgmt.PluginManager;

public class PluginExistsValidator
extends AbstractValidator {
    private final PluginManager<?, ?> pluginMgr;
    private final String id;
    private final ApiMessageKey messageKey;
    private final String fieldPath;
    private boolean excludeOverrides = false;

    public PluginExistsValidator(PluginManager<?, ?> pluginMgr, String id, String fieldPath, ApiMessageKey messageKey) {
        this.pluginMgr = pluginMgr;
        this.id = id;
        this.messageKey = messageKey;
        this.fieldPath = fieldPath;
    }

    public PluginExistsValidator(PluginManager<?, ?> pluginMgr, String id, String fieldPath, ApiMessageKey messageKey, boolean excludeOverrides) {
        this.pluginMgr = pluginMgr;
        this.id = id;
        this.messageKey = messageKey;
        this.fieldPath = fieldPath;
        this.excludeOverrides = excludeOverrides;
    }

    public boolean validate() {
        boolean valid;
        ConfigurablePluginInstance instance = this.pluginMgr.getInstance(this.id);
        boolean bl = valid = instance != null;
        if (valid && this.excludeOverrides && (instance.isConnectionBasedPlugin() || !StringUtils.equals((String)instance.getId(), (String)this.id))) {
            valid = false;
        }
        if (!valid) {
            this.appendError(ValidationErrorFactory.getInstance().create(this.messageKey, this.fieldPath, new Object[]{this.id}));
        }
        return valid;
    }
}

