/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.PluginInstancePaths;
import com.pingidentity.admin.api.validator.PluginFieldValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.HashedField;
import org.sourceid.saml20.adapter.gui.AbstractSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.HashedTextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.RadioGroupFieldDescriptor;
import org.sourceid.saml20.adapter.gui.SelectFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TextAreaFieldDescriptor;

public class PluginFieldsValidator
extends AbstractValidator {
    protected List<Field> fields;
    protected List<FieldDescriptor> fieldDescriptors;
    protected String fieldsPath;
    protected ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private Map<String, Integer> fieldIndices = null;
    private ValidatorContext validatorContext = null;

    protected PluginFieldsValidator() {
    }

    public PluginFieldsValidator(List<Field> fields, List<FieldDescriptor> fieldDescriptors, String fieldsPath) {
        this(fields, fieldDescriptors, fieldsPath, null, null);
    }

    public PluginFieldsValidator(List<Field> fields, List<FieldDescriptor> fieldDescriptors, String fieldsPath, Map<String, Integer> fieldIndices) {
        this(fields, fieldDescriptors, fieldsPath, fieldIndices, null);
    }

    public PluginFieldsValidator(List<Field> fields, List<FieldDescriptor> fieldDescriptors, String fieldsPath, Map<String, Integer> fieldIndices, ValidatorContext validatorContext) {
        this.fields = fields;
        this.fieldDescriptors = fieldDescriptors;
        this.fieldsPath = fieldsPath;
        this.fieldIndices = fieldIndices;
        this.validatorContext = validatorContext;
    }

    /*
     * WARNING - void declaration
     */
    public boolean validate() {
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        HashMap<String, Integer> currentFieldIndexMap = new HashMap<String, Integer>();
        int i = 0;
        for (Field field : this.fields) {
            fieldMap.put(field.getName(), field);
            currentFieldIndexMap.put(field.getName(), i);
            ++i;
        }
        HashMap<String, FieldDescriptor> fieldDescriptorMap = new HashMap<String, FieldDescriptor>();
        for (FieldDescriptor fieldDescriptor : this.fieldDescriptors) {
            fieldDescriptorMap.put(fieldDescriptor.getName(), fieldDescriptor);
        }
        int n = -1;
        for (Field field : this.fields) {
            void var5_8;
            String fieldNamePath = this.getFieldPath(field.getName(), (int)(++var5_8)) + "." + PluginInstancePaths.FieldPaths.getName();
            if (field.getName() == null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.plugin_field_name_required, fieldNamePath));
                continue;
            }
            if (fieldDescriptorMap.containsKey(field.getName())) continue;
            this.appendError(this.errorFactory.create(ApiMessageKey.plugin_field_name_not_recognized, fieldNamePath, new Object[]{field.getName()}));
        }
        if (!this.hasErrors()) {
            for (FieldDescriptor fieldDescriptor : this.fieldDescriptors) {
                Object field = (Field)fieldMap.get(fieldDescriptor.getName());
                Object fieldPath = this.fieldsPath;
                boolean isHashedField = fieldDescriptor instanceof HashedTextFieldDescriptor;
                String value = "";
                if (field != null) {
                    if (isHashedField) {
                        value = ((HashedField)field).getPlainTextValue();
                    } else {
                        value = field.getValue();
                        if (value == null) {
                            value = "";
                        }
                    }
                    fieldPath = this.getFieldPath(fieldDescriptor.getName(), (Integer)currentFieldIndexMap.get(fieldDescriptor.getName()));
                    if (this.fieldIndices == null || this.fieldIndices.containsKey(fieldDescriptor.getName())) {
                        fieldPath = (String)fieldPath + "." + PluginInstancePaths.FieldPaths.getValue();
                    }
                }
                if (!this.checkSelectionFieldValue(fieldDescriptor, (field = isHashedField ? new HashedField(fieldDescriptor.getName(), field.getValue(), value) : new Field(fieldDescriptor.getName(), fieldDescriptor.getLabel(), value)).getValue(), (String)fieldPath) || !this.checkCheckBoxFieldValue(fieldDescriptor, field.getValue(), (String)fieldPath) || !this.validateTextArea(fieldDescriptor, field.getValue(), (String)fieldPath)) continue;
                PluginFieldValidator fieldValidator = new PluginFieldValidator(fieldDescriptor, (Field)field, (String)fieldPath, this.validatorContext);
                fieldValidator.validate();
                this.appendErrors(fieldValidator.getErrors());
            }
        }
        return !this.hasErrors();
    }

    private boolean checkSelectionFieldValue(FieldDescriptor fieldDescriptor, String value, String fieldPath) {
        boolean result = true;
        if (fieldDescriptor instanceof AbstractSelectionFieldDescriptor) {
            boolean foundValue = false;
            AbstractSelectionFieldDescriptor selectionDesc = (AbstractSelectionFieldDescriptor)fieldDescriptor;
            if ((fieldDescriptor instanceof RadioGroupFieldDescriptor || fieldDescriptor instanceof SelectFieldDescriptor) && StringUtils.isBlank((String)selectionDesc.getDefaultValue()) && StringUtils.isBlank((String)value)) {
                foundValue = true;
            }
            if (!foundValue) {
                for (AbstractSelectionFieldDescriptor.OptionValue option : selectionDesc.getOptionValues()) {
                    if (option.getValue() == null || !option.getValue().equals(value)) continue;
                    foundValue = true;
                    break;
                }
            }
            if (!foundValue) {
                result = false;
                String errorMsg = "'" + value + "' is not a valid selection for '" + fieldDescriptor.getName() + "'";
                this.appendError(new ValidationError(ApiMessageKey.plugin_validation_error.toString(), errorMsg, fieldPath));
            }
        }
        return result;
    }

    private boolean checkCheckBoxFieldValue(FieldDescriptor fieldDescriptor, String value, String fieldPath) {
        boolean result = true;
        if (fieldDescriptor instanceof CheckBoxFieldDescriptor && !StringUtils.isEmpty((String)value) && !value.equals("false") && !value.equals("true")) {
            result = false;
            String errorMsg = "'" + fieldDescriptor.getName() + "' value must be either 'false' or 'true'";
            this.appendError(new ValidationError(ApiMessageKey.plugin_validation_error.toString(), errorMsg, fieldPath));
        }
        return result;
    }

    private boolean validateTextArea(FieldDescriptor fieldDescriptor, String value, String fieldPath) {
        boolean result = true;
        if (fieldDescriptor instanceof TextAreaFieldDescriptor && ((TextAreaFieldDescriptor)fieldDescriptor).isExpression() && StringUtils.isNotEmpty((String)value) && this.validatorContext != null && !this.validatorContext.isAllowExpressionUpdates()) {
            result = false;
            String errorMsg = "'" + fieldDescriptor.getName() + "' cannot be updated. Expression Admin Role is required to update resources with expressions.";
            this.appendError(new ValidationError(ApiMessageKey.plugin_validation_error.toString(), errorMsg, fieldPath));
        }
        return result;
    }

    protected String getFieldPath(String fieldName, int currentFieldIndex) {
        if (this.fieldIndices == null) {
            return this.fieldsPath + "[" + currentFieldIndex + "]";
        }
        Integer index = this.fieldIndices.get(fieldName);
        if (index == null) {
            return this.fieldsPath;
        }
        return this.fieldsPath + "[" + index + "]";
    }
}

