/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.PluginInstancePaths;
import com.pingidentity.admin.api.validator.PluginFieldsValidator;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.FieldList;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.adapter.gui.validation.EnhancedRowValidator;
import org.sourceid.saml20.adapter.gui.validation.RowValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;

public class PluginTableRowValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(PluginTableRowValidator.class);
    private FieldList row;
    private String rowPath;
    private TableDescriptor tableDescriptor;
    private Configuration config;
    private ValidatorContext validatorContext;

    public PluginTableRowValidator(FieldList row, String rowPath, TableDescriptor tableDescriptor, Configuration config, ValidatorContext validatorContext) {
        this.row = row;
        this.rowPath = rowPath;
        this.tableDescriptor = tableDescriptor;
        this.config = config;
        this.validatorContext = validatorContext;
    }

    public boolean validate() {
        PluginFieldsValidator fieldsValidator = new PluginFieldsValidator(this.row.getFields(), this.tableDescriptor.getRowFields(), this.rowPath + "." + PluginInstancePaths.RowPaths.getFields(), null, this.validatorContext);
        fieldsValidator.validate();
        this.appendErrors(fieldsValidator.getErrors());
        if (this.hasErrors()) {
            return false;
        }
        for (RowValidator rowValidator : this.tableDescriptor.getValidationChain()) {
            try {
                rowValidator.validate(this.row);
                if (!(rowValidator instanceof EnhancedRowValidator)) continue;
                EnhancedRowValidator enhancedRowValidator = (EnhancedRowValidator)rowValidator;
                enhancedRowValidator.validate(this.row, this.config);
            }
            catch (ValidationException e) {
                for (String errorMsg : e.getErrorMessages()) {
                    this.appendError(new ValidationError(ApiMessageKey.plugin_validation_error.toString(), errorMsg, this.rowPath));
                }
                break;
            }
            catch (Exception e) {
                String msg = "Unexpected exception thrown from " + rowValidator;
                this.appendError(new ValidationError(ApiMessageKey.plugin_validation_error.toString(), msg, this.rowPath));
                log.warn((Object)(msg + ": " + e));
            }
        }
        return !this.hasErrors();
    }
}

