/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.adapter.gui.validation.TableValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;

public class PluginTableValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(PluginTableValidator.class);
    private final Table table;
    private final String tablePath;
    private final TableDescriptor tableDescriptor;

    public PluginTableValidator(Table table, String tablePath, TableDescriptor tableDescriptor) {
        this.table = table;
        this.tablePath = tablePath;
        this.tableDescriptor = tableDescriptor;
    }

    public boolean validate() {
        for (TableValidator tableValidator : this.tableDescriptor.getTableValidationChain()) {
            try {
                tableValidator.validate(this.table);
            }
            catch (ValidationException e) {
                for (String errorMsg : e.getErrorMessages()) {
                    this.appendError(new ValidationError(ApiMessageKey.plugin_validation_error.toString(), errorMsg, this.tablePath));
                }
                break;
            }
            catch (Exception e) {
                String msg = "Unexpected exception thrown from " + tableValidator;
                this.appendError(new ValidationError(ApiMessageKey.plugin_validation_error.toString(), msg, this.tablePath));
                log.warn((Object)(msg + ": " + e));
            }
        }
        return !this.hasErrors();
    }
}

