/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.Attribute;
import com.pingidentity.admin.api.model.oauth.OpenIdConnectAttribute;
import com.pingidentity.admin.api.validator.AttributeContractValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.Validator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.sourceid.openid.connect.OpenIdParamNames;

public class PolicyAttributeContractValidator
extends AttributeContractValidator<OpenIdConnectAttribute> {
    private final String fieldPath;

    public PolicyAttributeContractValidator(List<OpenIdConnectAttribute> coreAttributes, List<OpenIdConnectAttribute> extendedAttributes, String contractFieldPath) {
        super(coreAttributes, extendedAttributes, contractFieldPath);
        this.fieldPath = contractFieldPath;
        this.addValidator((Validator)new OpenIdStandardAttributeValidator(extendedAttributes));
    }

    private class OpenIdStandardAttributeValidator
    extends AbstractValidator {
        private final List<OpenIdConnectAttribute> extendedAttributes;
        private Predicate<OpenIdConnectAttribute> openIdStandardAttrNotInIdToken = attr -> OpenIdParamNames.OPENID_IDTOKEN_STANDARD_CLAIMS.contains(attr.getName()) && !Boolean.TRUE.equals(attr.isIncludeInIdToken()) && attr.isIncludeInUserInfo() != null;
        private Predicate<OpenIdConnectAttribute> attrInIdTokenOrUserInfo = attr -> (attr.isIncludeInIdToken() != null || attr.isIncludeInUserInfo() != null) && !Boolean.TRUE.equals(attr.isIncludeInUserInfo()) && !Boolean.TRUE.equals(attr.isIncludeInIdToken());

        public OpenIdStandardAttributeValidator(List<OpenIdConnectAttribute> extendedAttributes) {
            this.extendedAttributes = extendedAttributes;
        }

        public boolean validate() {
            List attributesMustSelectAtleastOne;
            List attributesMissingIdTokenInclude = this.extendedAttributes.parallelStream().filter(this.openIdStandardAttrNotInIdToken).map(Attribute::getName).collect(Collectors.toList());
            if (attributesMissingIdTokenInclude.size() > 0) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.attribute_missing_in_id_token, PolicyAttributeContractValidator.this.fieldPath, new Object[]{String.join((CharSequence)", ", attributesMissingIdTokenInclude)}));
            }
            if ((attributesMustSelectAtleastOne = this.extendedAttributes.parallelStream().filter(this.attrInIdTokenOrUserInfo).map(Attribute::getName).collect(Collectors.toList())).size() > 0) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.attribute_must_select_id_token_or_user_info, PolicyAttributeContractValidator.this.fieldPath, new Object[]{String.join((CharSequence)", ", attributesMustSelectAtleastOne)}));
            }
            return !this.hasErrors();
        }
    }
}

