/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.oauth.ClientPaths;
import com.pingidentity.admin.api.model.fieldpaths.oauth.ClientSettingsPaths;
import com.pingidentity.admin.api.model.oauth.RefreshTokenRollingGracePeriodType;
import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.admin.api.validator.simple.IntegerValidator;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.domain.Client;

public final class RefreshTokenRollingGracePeriodValidator
extends AbstractValidator {
    private static final int REFRESH_TOKEN_ROLLING_GRACE_PERIOD_MIN_VALUE = 0;
    private static final int REFRESH_TOKEN_ROLLING_GRACE_PERIOD_MAX_VALUE = 86400;
    private static final String REFRESH_TOKEN_ROLLING_GRACE_PERIOD_TYPE_FRIENDLY_NAME = "Refresh Token Rolling Grace Period Type";
    private static final String REFRESH_TOKEN_ROLLING_GRACE_PERIOD_FRIENDLY_NAME = "Refresh Token Rolling Grace Period";
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private final String refreshTokenRollingGracePeriodType;
    private final String refreshTokenRollingGracePeriodTypePath;
    private final String refreshTokenRollingGracePeriod;
    private final String refreshTokenRollingGracePeriodPath;

    public static RefreshTokenRollingGracePeriodValidator newInstance(Client client) {
        String refreshTokenRollingGracePeriodStr = client.getRefreshTokenRollingGracePeriod() != null ? String.valueOf(client.getRefreshTokenRollingGracePeriod()) : null;
        return new RefreshTokenRollingGracePeriodValidator(client.getRefreshTokenRollingGracePeriodType(), ClientPaths.getRefreshTokenRollingGracePeriodTypePath(), refreshTokenRollingGracePeriodStr, ClientPaths.getRefreshTokenRollingGracePeriodPath());
    }

    public static RefreshTokenRollingGracePeriodValidator newClientSettingsInstance(String refreshTokenRollingGracePeriodType, String refreshTokenRollingGracePeriod) {
        return new RefreshTokenRollingGracePeriodValidator(refreshTokenRollingGracePeriodType, ClientSettingsPaths.getRefreshTokenRollingGracePeriodTypePath(), refreshTokenRollingGracePeriod, ClientSettingsPaths.getRefreshTokenRollingGracePeriodPath());
    }

    public RefreshTokenRollingGracePeriodValidator(String refreshTokenRollingGracePeriodType, String refreshTokenRollingGracePeriodTypePath, String refreshTokenRollingGracePeriod, String refreshTokenRollingGracePeriodPath) {
        this.refreshTokenRollingGracePeriodType = refreshTokenRollingGracePeriodType;
        this.refreshTokenRollingGracePeriod = refreshTokenRollingGracePeriod;
        this.refreshTokenRollingGracePeriodTypePath = refreshTokenRollingGracePeriodTypePath;
        this.refreshTokenRollingGracePeriodPath = refreshTokenRollingGracePeriodPath;
    }

    public boolean validate() {
        IntegerValidator refreshTokenRollingGracePeriodIntegerValidator;
        NotBlankValidator refreshTokenRollingGracePeriodTypeNotBlankValidator = new NotBlankValidator(this.refreshTokenRollingGracePeriodType, REFRESH_TOKEN_ROLLING_GRACE_PERIOD_TYPE_FRIENDLY_NAME, this.refreshTokenRollingGracePeriodTypePath);
        if (!refreshTokenRollingGracePeriodTypeNotBlankValidator.validate()) {
            this.appendErrors(refreshTokenRollingGracePeriodTypeNotBlankValidator.getErrors());
        } else if (RefreshTokenRollingGracePeriodType.getType(this.refreshTokenRollingGracePeriodType) == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.oauth_client_mgmt_refresh_token_rolling_grace_period_type_invalid, this.refreshTokenRollingGracePeriodTypePath));
        }
        if ("SERVER_DEFAULT".equals(this.refreshTokenRollingGracePeriodType) && StringUtils.isNotBlank((String)this.refreshTokenRollingGracePeriod)) {
            this.appendError(this.errorFactory.create(ApiMessageKey.oauth_client_mgmt_refresh_token_rolling_grace_period_value_and_type_mismatch, this.refreshTokenRollingGracePeriodPath));
        }
        if ("OVERRIDE_SERVER_DEFAULT".equals(this.refreshTokenRollingGracePeriodType) && !(refreshTokenRollingGracePeriodIntegerValidator = new IntegerValidator(this.refreshTokenRollingGracePeriod, REFRESH_TOKEN_ROLLING_GRACE_PERIOD_FRIENDLY_NAME, this.refreshTokenRollingGracePeriodPath, true, 0, 86400)).validate()) {
            this.appendErrors(refreshTokenRollingGracePeriodIntegerValidator.getErrors());
        }
        return !this.hasErrors();
    }
}

