/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.oauth.ClientPaths;
import com.pingidentity.admin.api.model.oauth.RefreshTokenRollingIntervalType;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.domain.RefreshTokenRollingIntervalHelper;

public class RefreshTokenRollingIntervalValidator
extends AbstractValidator {
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private final Long intervalTime;
    private final String intervalType;
    private final String intervalTimeUnit;

    public RefreshTokenRollingIntervalValidator(String refreshTokenRollingIntervalType, Long refreshTokenRollingInterval, String refreshTokenRollingIntervalTimeUnit) {
        this.intervalTime = refreshTokenRollingInterval;
        this.intervalType = refreshTokenRollingIntervalType;
        this.intervalTimeUnit = refreshTokenRollingIntervalTimeUnit == null ? "h" : refreshTokenRollingIntervalTimeUnit;
    }

    public boolean validate() {
        if ("OVERRIDE_SERVER_DEFAULT".equals(this.intervalType)) {
            if (!RefreshTokenRollingIntervalHelper.isValidTimeUnit((String)this.intervalTimeUnit)) {
                this.appendError(this.errorFactory.create(ApiMessageKey.oauth_client_mgmt_grant_refresh_token_rolling_interval_time_unit_invalid, ClientPaths.getRefreshTokenRollingIntervalTimeUnit(), new Object[]{this.intervalTimeUnit}));
            } else {
                long maxRefreshTokenRollingInterval = RefreshTokenRollingIntervalHelper.getMaxIntervalForUnit((String)this.intervalTimeUnit);
                if (this.intervalTime == null) {
                    this.appendError(this.errorFactory.create(ApiMessageKey.oauth_client_mgmt_grant_refresh_token_rolling_interval_required, ClientPaths.getRefreshTokenRollingInterval(), new Object[]{"Refresh Token Rolling Interval", "Refresh Token Rolling Interval type", "OVERRIDE_SERVER_DEFAULT"}));
                } else if (this.intervalTime < 0L || this.intervalTime > maxRefreshTokenRollingInterval) {
                    this.appendError(this.errorFactory.create(ApiMessageKey.oauth_client_mgmt_grant_refresh_token_rolling_interval, ClientPaths.getRefreshTokenRollingInterval(), new Object[]{0, maxRefreshTokenRollingInterval}));
                }
            }
        } else if (this.intervalTime != null && (RefreshTokenRollingIntervalType.SERVER_DEFAULT.getId().equals(this.intervalType) || StringUtils.isEmpty((String)this.intervalType))) {
            this.appendError(this.errorFactory.create(ApiMessageKey.oauth_client_mgmt_grant_refresh_token_rolling_interval_type_required, ClientPaths.getRefreshTokenRollingIntervalType(), new Object[]{"Refresh Token Rolling Interval type", RefreshTokenRollingIntervalType.OVERRIDE_SERVER_DEFAULT.getId(), "Refresh Token Rolling Interval"}));
        }
        return !this.hasErrors();
    }
}

