/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.ConditionalIssuanceCriteriaEntry;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.validator.ConditionalIssuanceCriteriaEntryValidator;
import com.pingidentity.admin.api.validator.RequestSourceTypeValidator;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.pf.common.api.validator.Validator;
import java.util.Collections;
import java.util.Set;

public class RequestSourceTypeValidatorBuilder
extends SourceTypeValidatorBuilder {
    private final Set<String> attributes;

    public RequestSourceTypeValidatorBuilder(Set<String> tokenAttributes) {
        this.attributes = tokenAttributes;
    }

    @Override
    public Validator buildMappingValidator(String attributeName, AttributeFulfillmentValue afv, String attributePath) {
        this.checkAndThrowForIllegalSourceType(afv.getSource().getType(), SourceType.REQUEST);
        return new RequestSourceTypeValidator(attributeName, afv.getValue(), this.attributes, attributePath, RequestSourceTypeValidator.RequestSourceTypeMsgContext.ATTR_MAPPING);
    }

    @Override
    public Validator buildConditionalIssuanceCriteriaValidator(ConditionalIssuanceCriteriaEntry icEntry, String attributePath) {
        this.checkAndThrowForIllegalSourceType(icEntry.getSource().getType(), SourceType.REQUEST);
        return new ConditionalIssuanceCriteriaEntryValidator((Validator)new RequestSourceTypeValidator(null, icEntry.getAttributeName(), this.attributes, attributePath, RequestSourceTypeValidator.RequestSourceTypeMsgContext.ISSUANCE_CRITERIA), icEntry, attributePath);
    }

    @Override
    public Set<String> getExposedSubstitutionVariables() {
        return Collections.unmodifiableSet(this.attributes);
    }

    @Override
    public boolean acceptsSubstitutionVariables() {
        return false;
    }
}

