/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.SaasAttributeMapping;
import com.pingidentity.admin.api.model.SchemaAttribute;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.SaasAttributeMappingValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import com.pingidentity.provisioner.mapping.FieldInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SaasAttributeMappingsValidator
extends CompositeValidator {
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private int index;
    private List<FieldInfo> fieldDesc;
    private List<SaasAttributeMapping> mappings;
    private Set<String> ldapNames;
    private List<SchemaAttribute> schemaAttributes;
    private ValidatorContext context;

    SaasAttributeMappingsValidator(int index, List<SaasAttributeMapping> mappings, List<FieldInfo> fieldDesc, Set<String> ldapNames, List<SchemaAttribute> schemaAttributes, ValidatorContext context) {
        this.index = index;
        this.fieldDesc = fieldDesc;
        this.mappings = mappings;
        this.ldapNames = ldapNames;
        this.schemaAttributes = schemaAttributes;
        this.context = context;
    }

    @Override
    public boolean validate() {
        for (FieldInfo feildInfo : this.fieldDesc) {
            boolean exists = false;
            for (SaasAttributeMapping mapping : this.mappings) {
                if (mapping.getFieldName() == null || !feildInfo.getCode().equals(mapping.getFieldName())) continue;
                exists = true;
            }
            if (exists || !feildInfo.isRequired()) continue;
            ValidationError error = this.errorFactory.create(ApiMessageKey.outbound_provisioning_channel_attribute_mapping_required, ConnectionPaths.OutboundProvisionPaths.getChannelAttributeMappings(this.index), new Object[]{feildInfo.getCode()});
            this.appendError(error);
        }
        int fieldIndex = 0;
        for (SaasAttributeMapping mapping : this.mappings) {
            ValidationError error;
            boolean exists = false;
            if (mapping.getFieldName() == null) {
                error = this.errorFactory.create(ApiMessageKey.field_required, ConnectionPaths.OutboundProvisionPaths.getChannelAttributeMappingFieldName(this.index, fieldIndex), new Object[]{ConnectionPaths.OutboundProvisionPaths.getChannelAttributeMappingFieldName(this.index, fieldIndex)});
                this.appendError(error);
            } else {
                for (FieldInfo feildInfo : this.fieldDesc) {
                    if (!feildInfo.getCode().equals(mapping.getFieldName())) continue;
                    exists = true;
                    this.addValidator((Validator)new SaasAttributeMappingValidator(this.index, mapping, feildInfo, this.ldapNames, fieldIndex, this.context));
                }
                if (!exists) {
                    exists = this.existsInCustomAttributes(mapping);
                    this.addValidator((Validator)new SaasAttributeMappingValidator(this.index, mapping, this.ldapNames, fieldIndex, this.context));
                }
                if (!exists) {
                    error = this.errorFactory.create(ApiMessageKey.outbound_provisioning_channel_attribute_unknown, ConnectionPaths.OutboundProvisionPaths.getChannelAttributeMappings(this.index), new Object[]{mapping.getFieldName()});
                    this.appendError(error);
                }
            }
            ++fieldIndex;
        }
        super.validate();
        return !this.hasErrors();
    }

    private boolean existsInCustomAttributes(SaasAttributeMapping mapping) {
        if (this.schemaAttributes != null) {
            for (SchemaAttribute schemaAttribute : this.schemaAttributes) {
                List<String> attributeNames = SaasAttributeMappingsValidator.getAttributeName(schemaAttribute);
                for (String attributeName : attributeNames) {
                    if (!mapping.getFieldName().equals(attributeName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static List<String> getAttributeName(SchemaAttribute schemaAttribute) {
        ArrayList<String> attributeNames = new ArrayList<String>();
        List<String> subAttrs = schemaAttribute.getSubAttributes();
        String attributeName = schemaAttribute.getName();
        if (schemaAttribute.isMultiValued().booleanValue() && schemaAttribute.getTypes() != null && !schemaAttribute.getTypes().isEmpty()) {
            for (String multiValuesTypeName : schemaAttribute.getTypes()) {
                String mappedTypeName = attributeName + "." + multiValuesTypeName;
                attributeNames.addAll(SaasAttributeMappingsValidator.getSubAttributeNames(subAttrs, mappedTypeName));
            }
        } else if (subAttrs != null && !subAttrs.isEmpty()) {
            attributeNames.addAll(SaasAttributeMappingsValidator.getSubAttributeNames(subAttrs, attributeName));
        } else {
            attributeNames.add(attributeName);
        }
        return attributeNames;
    }

    private static List<String> getSubAttributeNames(List<String> subAttrs, String prefix) {
        ArrayList<String> subAttributes = new ArrayList<String>();
        for (String subAttributeName : subAttrs) {
            subAttributes.add(prefix + "." + subAttributeName);
        }
        return subAttributes;
    }
}

