/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.ServerSettingsPaths;
import com.pingidentity.admin.api.model.systemsettings.CaptchaSettings;
import com.pingidentity.admin.api.model.systemsettings.EmailServerSettings;
import com.pingidentity.admin.api.model.systemsettings.NotificationSettings;
import com.pingidentity.admin.api.model.systemsettings.ServerSettings;
import com.pingidentity.admin.api.validator.CaptchaSettingsValidator;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.EmailServerSettingsValidator;
import com.pingidentity.admin.api.validator.EmailValidator;
import com.pingidentity.admin.api.validator.FederationInfoValidator;
import com.pingidentity.admin.api.validator.NotificationSettingsValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import org.sourceid.saml20.domain.NotificationMode;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.NotificationPublisherPluginManager;

public class ServerSettingsValidator
extends CompositeValidator {
    private static final NotificationPublisherPluginManager NOTIFICATION_PUBLISHER_PLUGIN_MGR = MgmtFactory.getNotificationPublisherPluginManager();

    public ServerSettingsValidator(final ServerSettings serverSettings, ValidatorContext validatorContext) {
        CaptchaSettings captchaSettings;
        this.addValidator((Validator)new EmailValidator(serverSettings.getContactInfo().getEmail(), ApiMessageKey.system_info_email_invalid, ServerSettingsPaths.ContactInfoPaths.getEmail()));
        FederationInfoValidator fv = new FederationInfoValidator.Builder().setBaseFieldPath(ServerSettingsPaths.getFederationInfo()).withFederationInfo(serverSettings.getFederationInfo()).build();
        this.addValidator((Validator)fv);
        EmailServerSettings emailSettings = serverSettings.getEmailServer();
        if (serverSettings.getNotifications() != null) {
            this.addValidator((Validator)new NotificationSettingsValidator(ServerSettingsPaths.getNotifications(), serverSettings.getNotifications(), emailSettings != null, validatorContext));
        }
        if (emailSettings != null) {
            EmailServerSettingsValidator emailSettingsValidator = new EmailServerSettingsValidator.Builder().withEmailSettings(emailSettings).setSkipValidateEmailServer(false).setPathPrefix(ServerSettingsPaths.getEmailServerSettings()).build();
            this.addValidator((Validator)emailSettingsValidator);
        }
        if ((captchaSettings = serverSettings.getCaptchaSettings()) != null) {
            CaptchaSettingsValidator captchaSettingsValidator = new CaptchaSettingsValidator.Builder().setSiteKey(captchaSettings.getSiteKey()).setSecretKey(captchaSettings.getSecretKey()).setEncryptedSecretKey(captchaSettings.getEncryptedSecretKey()).build();
            this.addValidator((Validator)captchaSettingsValidator);
        }
        this.addValidator((Validator)new AbstractValidator(){

            public boolean validate() {
                NotificationSettings apiSettings;
                if (serverSettings.getNotifications() != null && serverSettings.getNotifications().isAtLeastOneNotificationEnabled() && NOTIFICATION_PUBLISHER_PLUGIN_MGR.getDefaultInstance() == null && (serverSettings.getEmailServer() == null || serverSettings.getEmailServer() != null && !serverSettings.getEmailServer().isNotificationEmailSettingsPopulated()) && ((apiSettings = serverSettings.getNotifications()).getLicenseEvents() != null && apiSettings.getLicenseEvents().getNotificationPublisherRef() == null || apiSettings.getMetadataNotificationSettings() != null && apiSettings.getMetadataNotificationSettings().getNotificationPublisherRef() == null || apiSettings.getCertificateExpirations() != null && apiSettings.getCertificateExpirations().getNotificationMode() != NotificationMode.LOGGING_ONLY && apiSettings.getCertificateExpirations().getNotificationPublisherRef() == null || apiSettings.isNotifyAdminUserPasswordChanges() && apiSettings.getAccountChangesNotificationPublisherRef() == null)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.notifications_email_server_config_or_publisher_required, ServerSettingsPaths.getEmailServerSettings()));
                    return false;
                }
                return true;
            }
        });
    }

    private boolean valid(AbstractValidator validator) {
        boolean result = validator.validate();
        validator.clearErrors();
        return result;
    }
}

