/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.SigningSettings;
import com.pingidentity.admin.api.model.fieldpaths.SigningSettingsPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.List;
import org.sourceid.saml20.domain.DSignRotationSetting;
import org.sourceid.saml20.domain.mgmt.DSignRotationSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.util.MetadataImportExportUtil;

public class SigningSettingsValidator
extends AbstractValidator {
    private final DSignRotationSettingsManager dSignRotationManager;
    private final SigningSettings signingSettings;
    private final String baseFieldPath;

    public SigningSettingsValidator(DSignRotationSettingsManager dSignRotationManager, SigningSettings signingSettings, String baseFieldPath) {
        this.dSignRotationManager = dSignRotationManager;
        this.signingSettings = signingSettings;
        this.baseFieldPath = baseFieldPath;
    }

    public boolean validate() {
        if (this.signingSettings != null) {
            List<ResourceLink> altSigningKeyList = this.signingSettings.getAlternativeSigningKeyPairRefs();
            int idx = 0;
            if (altSigningKeyList != null) {
                String primarySigningKeyId;
                String string = primarySigningKeyId = this.signingSettings.getSigningKeyPairRef() != null ? this.signingSettings.getSigningKeyPairRef().getId() : null;
                if (!MetadataImportExportUtil.allowAlternativeSigningCert((String)primarySigningKeyId, (DSignRotationSettingsManager)this.dSignRotationManager)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.alternative_signing_cert_not_allowed, this.appendFieldPath(this.baseFieldPath, SigningSettingsPaths.getAlternativeSigningKeyPairRefs())));
                } else {
                    for (ResourceLink altSigningResourceLink : altSigningKeyList) {
                        String altSignKeyCertId = altSigningResourceLink.getId();
                        PkCert altSignCert = MgmtFactory.getDsigPkCertManager().getPkCert(altSignKeyCertId);
                        if (altSignCert == null) {
                            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.signing_key_pair_not_found, this.appendFieldPath(this.baseFieldPath, SigningSettingsPaths.getAltSigningKeyPairRef(idx)), new Object[]{altSignKeyCertId}));
                        } else {
                            DSignRotationSetting secondaryCertRotationSettings;
                            if (primarySigningKeyId != null && primarySigningKeyId.equals(altSignKeyCertId)) {
                                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.signing_primary_cert_same_as_alternative_cert, this.appendFieldPath(this.baseFieldPath, SigningSettingsPaths.getAltSigningKeyPairRef(idx)), new Object[]{altSignKeyCertId}));
                            }
                            if ((secondaryCertRotationSettings = this.dSignRotationManager.getRotationSetting(altSignKeyCertId)) != null && secondaryCertRotationSettings.isEnableCertRotation()) {
                                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.alternative_signing_cert_cannot_have_rotation_enabled, this.appendFieldPath(this.baseFieldPath, SigningSettingsPaths.getAltSigningKeyPairRef(idx))));
                            }
                        }
                        ++idx;
                    }
                }
            }
        }
        return !this.hasErrors();
    }
}

