/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.IdpBrowserSso;
import com.pingidentity.admin.api.model.IdpIdentityMapping;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.model.SpAdapterMapping;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.model.plugin.SpAdapter;
import com.pingidentity.admin.api.model.plugin.SpAdapterAttribute;
import com.pingidentity.admin.api.model.plugin.SpAdapterAttributeContract;
import com.pingidentity.admin.api.translator.plugin.PluginEnum;
import com.pingidentity.admin.api.validator.AttributeMappingValidator;
import com.pingidentity.admin.api.validator.AttributeSetSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ExpressionSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ExtendedMetadataSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.NoMappingTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.OnlyOneAttributeSourceValidator;
import com.pingidentity.admin.api.validator.PluginExistsValidator;
import com.pingidentity.admin.api.validator.ResourceIdValidator;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.SpAdapterValidator;
import com.pingidentity.admin.api.validator.TargetSessionMappingsValidator;
import com.pingidentity.admin.api.validator.UniqueEntriesValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PluginManager;

public class SpAdapterMappingsValidator
extends TargetSessionMappingsValidator {
    public SpAdapterMappingsValidator(IdpBrowserSso browserSso, List<String> availableVirtualServerIds, ValidatorContext context) {
        super(browserSso, availableVirtualServerIds, context);
        if (IdpIdentityMapping.NONE == browserSso.getIdpIdentityMapping()) {
            return;
        }
        if (browserSso.getAdapterMappings().isEmpty() && browserSso.getAuthenticationPolicyContractMappings().isEmpty()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.target_session_mappings_empty, ConnectionPaths.getTargetSessionMappingsPath()));
        }
        List<SpAdapterMapping> mappings = browserSso.getAdapterMappings();
        UniqueEntriesValidator.UniqueKeyGetter<SpAdapterMapping> spAdapterRefKeyGetter = new UniqueEntriesValidator.UniqueKeyGetter<SpAdapterMapping>(){

            @Override
            public String getKey(SpAdapterMapping object) {
                if (object.hasAdapterOverride()) {
                    if (object.getAdapterOverrideSettings().getParentRef() != null && object.getAdapterOverrideSettings().getParentRef().getId() != null) {
                        return object.getAdapterOverrideSettings().getParentRef().getId().toLowerCase();
                    }
                } else if (object.getSpAdapterRef() != null && object.getSpAdapterRef().getId() != null) {
                    return object.getSpAdapterRef().getId().toLowerCase();
                }
                return null;
            }
        };
        this.addValidator((Validator)new UniqueEntriesValidator<SpAdapterMapping>(spAdapterRefKeyGetter, mappings, ConnectionPaths.getSpAdapterMappingsPath(), ApiMessageKey.sp_adapter_mappings_duplicate_mappings));
        this.setSpAdapterMappingsValidators(browserSso, context);
    }

    SpAdapterMappingsValidator(IdpBrowserSso browserSso) {
        this(browserSso, Collections.emptyList(), new ValidatorContext());
    }

    private void setSpAdapterMappingsValidators(IdpBrowserSso browserSso, ValidatorContext validatorContext) {
        List<SpAdapterMapping> mappings = browserSso.getAdapterMappings();
        int mappingIndex = 0;
        for (SpAdapterMapping mapping : mappings) {
            HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> rootSources = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>();
            AttributeSetSourceTypeValidatorBuilder assertionSourceTypeBuilder = this.createAssertionValBuilder(browserSso);
            rootSources.put(new SourceTypeIdKey(SourceType.ACCOUNT_LINK), this.createAccountLinkValBuilder(browserSso));
            rootSources.put(new SourceTypeIdKey(SourceType.CONTEXT), this.createContextTypeBuilder());
            rootSources.put(new SourceTypeIdKey(SourceType.NO_MAPPING), new NoMappingTypeValidatorBuilder());
            rootSources.put(new SourceTypeIdKey(SourceType.TEXT), this.createTextValBuilder());
            rootSources.put(new SourceTypeIdKey(SourceType.EXTENDED_PROPERTIES), new ExtendedMetadataSourceTypeValidatorBuilder(SourceType.EXTENDED_PROPERTIES));
            if (browserSso.getProtocol() == Protocol.OIDC) {
                rootSources.put(new SourceTypeIdKey(SourceType.CLAIMS), assertionSourceTypeBuilder);
            } else {
                rootSources.put(new SourceTypeIdKey(SourceType.ASSERTION), assertionSourceTypeBuilder);
            }
            ExpressionManager expressionManager = ExpressionManager.getInstance();
            if (expressionManager.isEvaluateExpressionsOn()) {
                rootSources.put(new SourceTypeIdKey(SourceType.EXPRESSION), new ExpressionSourceTypeValidatorBuilder(this.getContext()));
            }
            HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>(rootSources);
            validSources.put(new SourceTypeIdKey(SourceType.LDAP_DATA_STORE), this.createDsValBuilder(SourceType.LDAP_DATA_STORE, mapping));
            validSources.put(new SourceTypeIdKey(SourceType.JDBC_DATA_STORE), this.createDsValBuilder(SourceType.JDBC_DATA_STORE, mapping));
            validSources.put(new SourceTypeIdKey(SourceType.CUSTOM_DATA_STORE), this.createDsValBuilder(SourceType.CUSTOM_DATA_STORE, mapping));
            ResourceLink spAdapterRef = mapping.getSpAdapterRef();
            String adapterRefFieldName = "SP Adapter reference";
            boolean hasAdapterOverride = mapping.hasAdapterOverride();
            SpAdapter overrideAdapter = null;
            if (hasAdapterOverride) {
                overrideAdapter = mapping.getAdapterOverrideSettings();
                if (overrideAdapter.getParentRef() != null) {
                    spAdapterRef = overrideAdapter.getParentRef();
                    this.setOverrideAdapterWithParentAdapterInfo(overrideAdapter);
                    overrideAdapter.setId("");
                    this.addValidator((Validator)new SpAdapterValidator(overrideAdapter, false, true, ConnectionPaths.getSpAdapterMappingAttributeAdapterOverrideSettings(mappingIndex), validatorContext));
                }
                adapterRefFieldName = "Adapter Override's Parent SP Adapter reference";
                this.addValidator((Validator)new ResourceIdValidator(spAdapterRef, adapterRefFieldName, ConnectionPaths.getSpAdapterOverrideSettingsParentRefPath(mappingIndex)));
            } else {
                this.addValidator((Validator)new ResourceIdValidator(spAdapterRef, adapterRefFieldName, ConnectionPaths.getSpAdapterMappingAdapterLinkPath(mappingIndex)));
                if (spAdapterRef != null) {
                    this.addValidator((Validator)new PluginExistsValidator((PluginManager<?, ?>)MgmtFactory.getSpAdapterManager(), spAdapterRef.getId(), ConnectionPaths.getSpAdapterMappingAdapterLinkIdPath(mappingIndex), ApiMessageKey.sp_adapter_not_found, true));
                }
            }
            HashSet<String> adapterContract = new HashSet();
            if (spAdapterRef != null && spAdapterRef.getId() != null) {
                String adapterId = spAdapterRef.getId();
                adapterContract = this.getAttributeContractFromAdapter(hasAdapterOverride ? overrideAdapter.getAttributeContract() : null, adapterId);
            }
            String fieldPath = ConnectionPaths.getSpAdapterMappingAttributeSourcePath(mappingIndex);
            this.addValidator((Validator)new OnlyOneAttributeSourceValidator(mapping.getAttributeSources().size(), ApiMessageKey.sp_adapter_mapping_multiple_attribute_source, fieldPath));
            String adapterMappingPath = ConnectionPaths.getSpAdapterMappingsPath(mappingIndex);
            HashSet<String> sourceSubstitutionAttrs = new HashSet<String>();
            sourceSubstitutionAttrs.addAll(assertionSourceTypeBuilder.getAssertionAttributes());
            if (browserSso.getIdpIdentityMapping() == IdpIdentityMapping.ACCOUNT_LINKING) {
                sourceSubstitutionAttrs.add(IdpConnection.getLocalIdSubstitutionKey());
            }
            this.addValidator((Validator)new AttributeMappingValidator(mapping, adapterContract, sourceSubstitutionAttrs, "assertion", validSources, adapterMappingPath, this.getContext()));
            ++mappingIndex;
        }
    }

    private Set<String> getAttributeContractFromAdapter(SpAdapterAttributeContract adapterOverrideAttributeContract, String adapterId) {
        AuthnAdapterInstance spAdapter;
        Set<String> adapterContract = new HashSet<String>();
        if (adapterOverrideAttributeContract != null) {
            LinkedList<SpAdapterAttribute> allAttributesList = new LinkedList<SpAdapterAttribute>();
            allAttributesList.addAll(adapterOverrideAttributeContract.getCoreAttributes());
            List<SpAdapterAttribute> extendedAttributesList = adapterOverrideAttributeContract.getExtendedAttributes();
            if (extendedAttributesList != null) {
                allAttributesList.addAll(extendedAttributesList);
            }
            adapterContract = allAttributesList.stream().map(n -> n.getName()).collect(Collectors.toSet());
        } else if (StringUtils.isNotBlank((String)adapterId) && (spAdapter = (AuthnAdapterInstance)MgmtFactory.getSpAdapterManager().getInstance(adapterId)) != null) {
            adapterContract.addAll(spAdapter.getAttributeContract().getAllAttributeNames());
        }
        return adapterContract;
    }

    @Override
    public boolean validate() {
        if (IdpIdentityMapping.NONE == this.browserSso.getIdpIdentityMapping() && !this.browserSso.getAdapterMappings().isEmpty()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.attribute_mapping_not_required, ConnectionPaths.getSpAdapterMappingsPath()));
            return false;
        }
        super.validate();
        boolean noVsidErrorFound = false;
        int mappingIndex = 0;
        for (SpAdapterMapping adapterMapping : this.browserSso.getAdapterMappings()) {
            int vsidIndex = 0;
            if (adapterMapping.isRestrictVirtualEntityIds() && this.availableVirtualServerIds.isEmpty() && !noVsidErrorFound) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.restricted_virtual_entity_id_not_required, ConnectionPaths.getSpAdapterMappingRestrictedVirtualEntityIdPath(mappingIndex)));
                noVsidErrorFound = true;
            } else if (!adapterMapping.isRestrictVirtualEntityIds() && !adapterMapping.getRestrictedVirtualEntityIds().isEmpty()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.restricted_virtual_entity_ids_not_allowed, ConnectionPaths.getSpAdapterMappingRestrictedVirtualEntityIdPath(mappingIndex)));
            } else if (adapterMapping.isRestrictVirtualEntityIds() && adapterMapping.getRestrictedVirtualEntityIds().isEmpty()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.restricted_virtual_entity_ids_required, ConnectionPaths.getSpAdapterMappingRestrictedVirtualEntityIdPath(mappingIndex)));
            } else {
                ArrayList<String> seenEntityIds = new ArrayList<String>(adapterMapping.getRestrictedVirtualEntityIds().size());
                for (String virtualEntityId : adapterMapping.getRestrictedVirtualEntityIds()) {
                    String virtualEntityPath = ConnectionPaths.getSpAdapterMappingRestrictedVirtualEntityIdPath(mappingIndex, vsidIndex);
                    if (seenEntityIds.contains(virtualEntityId)) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.restricted_virtual_entity_id_duplicate, virtualEntityPath, new Object[]{virtualEntityId}));
                    } else if (!this.availableVirtualServerIds.contains(virtualEntityId)) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.attribute_mapping_value_invalid_virtual_entity_id, virtualEntityPath, new Object[]{virtualEntityId}));
                    }
                    seenEntityIds.add(virtualEntityId);
                    ++vsidIndex;
                }
            }
            if (adapterMapping.hasAdapterOverride() && adapterMapping.getSpAdapterRef() != null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.attribute_mapping_has_sp_adapter_ref_and_override_parent_ref, ConnectionPaths.getSpAdapterMappingAdapterLinkPath(mappingIndex)));
            }
            ++mappingIndex;
        }
        return !this.hasErrors();
    }

    private void setOverrideAdapterWithParentAdapterInfo(SpAdapter overrideAdapter) {
        ResourceLink parentAdapterRef = overrideAdapter.getParentRef();
        AuthnAdapterInstance parentAdapter = (AuthnAdapterInstance)MgmtFactory.getSpAdapterManager().getInstance(parentAdapterRef.getId());
        if (parentAdapter != null) {
            String typeId = parentAdapter.getDescriptor().getPluginClassName();
            String pluginDescriptorUrl = ApiUtil.getResourceUrl(PluginEnum.SP_ADAPTER.getDescriptorsResourcePath(), typeId);
            overrideAdapter.setPluginDescriptorRef(new ResourceLink(typeId, pluginDescriptorUrl));
            overrideAdapter.setName(parentAdapter.getName() + " (with override)");
        } else {
            overrideAdapter.setPluginDescriptorRef(new ResourceLink("", ""));
            overrideAdapter.setName("");
        }
    }
}

