/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.SpBrowserSsoAttribute;
import com.pingidentity.admin.api.model.SpConnection;
import com.pingidentity.admin.api.model.SpSamlIdentityMapping;
import com.pingidentity.admin.api.model.WsFedTokenType;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.AttributeContractValidator;
import com.pingidentity.admin.api.validator.AttributeNameFormatValidator;
import com.pingidentity.admin.api.validator.ListEmptyValidator;
import com.pingidentity.admin.api.validator.ListNotEmptyValidator;
import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.admin.api.validator.SubjectNameFormatValidator;
import com.pingidentity.admin.api.validator.UniqueEntriesValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SpAttributeContractValidator
extends AttributeContractValidator<SpBrowserSsoAttribute> {
    public SpAttributeContractValidator(SpConnection spConn, List<SpBrowserSsoAttribute> coreAttributes, List<SpBrowserSsoAttribute> extendedAttributes, String contractFieldPath) {
        super(coreAttributes, extendedAttributes, contractFieldPath, spConn);
        int index = 0;
        String coreAttributePath = ConnectionPaths.getCoreAttributes(contractFieldPath);
        String extAttributePath = ConnectionPaths.getExtendedAttributesPath(contractFieldPath);
        for (SpBrowserSsoAttribute attr : spConn.getSpBrowserSso().getAttributeContract().getCoreAttributes()) {
            if (spConn.getSpBrowserSso().getProtocol() != Protocol.WSFED) {
                this.addValidator((Validator)new SubjectNameFormatValidator(attr.getNameFormat(), coreAttributePath, index++, spConn.getBrowserSso()));
                continue;
            }
            if (!StringUtils.isNotBlank((String)attr.getNameFormat())) continue;
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, ConnectionPaths.getAttributeContractAttributeNameFormat(coreAttributePath, index++), new Object[]{"nameformat"}));
        }
        if (this.isIncludeExtendedAttributeNameFormat(spConn)) {
            index = 0;
            for (SpBrowserSsoAttribute attr : spConn.getSpBrowserSso().getAttributeContract().getExtendedAttributes()) {
                this.addValidator((Validator)new AttributeNameFormatValidator(attr.getNameFormat(), extAttributePath, index++, spConn.getSpBrowserSso().getProtocol()));
            }
        } else if (spConn.getSpBrowserSso().getProtocol() != Protocol.WSFED || spConn.getSpBrowserSso().getWsFedTokenType() != WsFedTokenType.SAML20) {
            index = 0;
            for (SpBrowserSsoAttribute attr : spConn.getSpBrowserSso().getAttributeContract().getExtendedAttributes()) {
                if (StringUtils.isNotBlank((String)attr.getNameFormat())) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, ConnectionPaths.getAttributeContractAttributeNameFormat(extAttributePath, index), new Object[]{"nameformat"}));
                }
                ++index;
            }
        }
        if (spConn.getSpBrowserSso().getSpSamlIdentityMapping() != null) {
            if (spConn.getSpBrowserSso().getSpSamlIdentityMapping().equals((Object)SpSamlIdentityMapping.STANDARD)) {
                this.addValidator((Validator)new ListNotEmptyValidator(spConn.getSpBrowserSso().getAttributeContract().getCoreAttributes(), ApiMessageKey.list_cannot_contain_empty_entries, ConnectionPaths.getAttributeContractCoreAttributes(contractFieldPath)));
            } else {
                this.addValidator((Validator)new ListEmptyValidator(spConn.getSpBrowserSso().getAttributeContract().getCoreAttributes(), ApiMessageKey.list_cannot_contain_entries, ConnectionPaths.getAttributeContractCoreAttributes(contractFieldPath)));
            }
        }
    }

    @Override
    public void addAdditionalValidators(List<SpBrowserSsoAttribute> attributes, String contractFieldPath, UniqueEntriesValidator.UniqueKeyGetter<SpBrowserSsoAttribute> attrKeyGetter) {
        this.addValidator((Validator)new UniqueEntriesValidator<SpBrowserSsoAttribute>(attrKeyGetter, attributes, contractFieldPath, ApiMessageKey.attribute_contract_duplicate_entry));
    }

    @Override
    public void createAttributeValidator(SpBrowserSsoAttribute attribute, String contractFieldPath, int i) {
        SpBrowserSsoAttribute attr = attribute;
        this.addValidator((Validator)new NotBlankValidator(attr.getName(), "name", ConnectionPaths.getAttributeContractAttributeName(contractFieldPath, i)));
        if (this.connection != null && !Protocol.isSaml1x(this.connection.getBrowserSso().getProtocol())) {
            this.addValidator((Validator)new NotBlankValidator(attr.getNameFormat(), "nameFormat", ConnectionPaths.getAttributeContractAttributeNameFormat(contractFieldPath, i)));
        }
    }
}

