/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.EncryptionPolicy;
import com.pingidentity.admin.api.model.Profile;
import com.pingidentity.admin.api.model.SpConnection;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.AbstractDecryptionKeyPairValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;

public class SpDecryptionKeyPairValidator
extends AbstractDecryptionKeyPairValidator {
    private EncryptionPolicy policy;
    private SpConnection connection;

    public SpDecryptionKeyPairValidator(SpConnection connection, boolean fullValidationPath) {
        super(connection.getCredentials(), fullValidationPath);
        this.connection = connection;
        if (connection.getSpBrowserSso() != null) {
            this.policy = connection.getSpBrowserSso().getEncryptionPolicy();
        }
    }

    @Override
    public boolean validate() {
        if (this.isBrowserSsoPolicyExists() && this.isBrowserSsoDecryptionRequired() && !this.connection.getSpBrowserSso().getEnabledProfiles().contains((Object)Profile.SP_INITIATED_SLO)) {
            String path = ConnectionPaths.getEncryptionPolicyEncryptSubjectPath(this.connection.getType().getRole());
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, path, new Object[]{path}));
        }
        return super.validate();
    }

    private boolean isBrowserSsoPolicyExists() {
        return this.connection != null && this.connection.isBrowserSsoSaml2() && this.policy != null;
    }

    private boolean isBrowserSsoDecryptionRequired() {
        if (this.isBrowserSsoPolicyExists()) {
            return this.policy.isSloSubjectNameIDEncrypted();
        }
        return false;
    }

    private boolean isAttributeQueryDecryptionRequired() {
        if (this.connection.getAttributeQuery() != null) {
            return this.connection.getAttributeQuery().getPolicy().isRequireEncryptedNameId();
        }
        return false;
    }

    @Override
    protected boolean isDecryptionRequired() {
        return this.isBrowserSsoDecryptionRequired() || this.isAttributeQueryDecryptionRequired();
    }
}

