/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.SpWsTrust;
import com.pingidentity.admin.api.model.SpWsTrustAttribute;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.AttributeContractValidator;
import com.pingidentity.admin.api.validator.WsTrustAttributeNameSpaceValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sourceid.wstrust.model.Saml11O365SecurityToken;
import org.sourceid.wstrust.model.Saml11SecurityToken;
import org.sourceid.wstrust.model.Saml20SecurityToken;

public class SpWsTrustAttributeContractValidator
extends AttributeContractValidator<SpWsTrustAttribute> {
    public SpWsTrustAttributeContractValidator(SpWsTrust wsTrustSettings, List<SpWsTrustAttribute> coreAttributes, List<SpWsTrustAttribute> extendedAttributes, String contractFieldPath) {
        super(coreAttributes, extendedAttributes, contractFieldPath);
        String domainSamlTokenType = wsTrustSettings.getDefaultTokenType().getId();
        if (Saml11SecurityToken.TYPE.equals(domainSamlTokenType) || Saml11O365SecurityToken.TYPE.equals(domainSamlTokenType) || Saml20SecurityToken.TYPE.equals(domainSamlTokenType)) {
            int index = 0;
            for (SpWsTrustAttribute attr : wsTrustSettings.getAttributeContract().getExtendedAttributes()) {
                WsTrustAttributeNameSpaceValidator nameFormatValidator = new WsTrustAttributeNameSpaceValidator(attr.getNamespace(), domainSamlTokenType, index);
                this.addValidator((Validator)nameFormatValidator);
                ++index;
            }
        } else {
            int index = 0;
            for (SpWsTrustAttribute attr : wsTrustSettings.getAttributeContract().getExtendedAttributes()) {
                if (StringUtils.isNotBlank((String)attr.getNamespace())) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, ConnectionPaths.WsTrustPaths.getAttributeContractExtended(index), new Object[]{"Name Space"}));
                }
                ++index;
            }
        }
    }
}

