/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.ValidationUtil;

public class SpWsTrustTokenLifetimeValidator
extends AbstractValidator {
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private String tokenLifetimeBeforeMinutes;
    private String tokenLifetimeAfterMinutes;

    public SpWsTrustTokenLifetimeValidator(String tokenLifetimeBeforeMinutes, String tokenLifetimeAfterMinutes) {
        this.tokenLifetimeBeforeMinutes = tokenLifetimeBeforeMinutes;
        this.tokenLifetimeAfterMinutes = tokenLifetimeAfterMinutes;
    }

    public boolean validate() {
        ValidationError error;
        if (!StringUtils.isBlank((String)this.tokenLifetimeBeforeMinutes)) {
            if (!ValidationUtil.isValidPosUnsignedShortGreaterThanZero((String)this.tokenLifetimeBeforeMinutes)) {
                error = this.errorFactory.create(ApiMessageKey.token_lifetime_before_range, ConnectionPaths.WsTrustPaths.getMinutesBefore());
                this.appendError(error);
            }
        } else {
            error = this.errorFactory.create(ApiMessageKey.token_lifetime_before_required, ConnectionPaths.WsTrustPaths.getMinutesBefore());
            this.appendError(error);
        }
        if (!StringUtils.isBlank((String)this.tokenLifetimeAfterMinutes)) {
            if (!ValidationUtil.isValidInt((String)this.tokenLifetimeAfterMinutes, (int)1, (int)525600)) {
                error = this.errorFactory.create(ApiMessageKey.token_lifetime_after_range, ConnectionPaths.WsTrustPaths.getMinutesAfter());
                this.appendError(error);
            }
        } else {
            error = this.errorFactory.create(ApiMessageKey.token_lifetime_after_required, ConnectionPaths.WsTrustPaths.getMinutesAfter());
            this.appendError(error);
        }
        return !this.hasErrors();
    }
}

