/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.SystemKey;
import com.pingidentity.admin.api.model.SystemKeys;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.util.B64;
import com.pingidentity.common.util.Obfuscator;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;

public class SystemKeysValidator
extends AbstractValidator {
    private static final String FIELD_KEY_DATA = "keyData";
    private static final String FIELD_ENCRYPTED_KEY_DATA = "encryptedKeyData";
    private SystemKeys keys;
    private boolean isCreate;

    public SystemKeysValidator(SystemKeys systemKeys, boolean isCreate) {
        this.keys = systemKeys;
        this.isCreate = isCreate;
    }

    public boolean validate() {
        if (!this.isCreate) {
            this.validateKey(this.keys.getCurrent(), "current", true);
            this.validateKey(this.keys.getPending(), "pending", true);
            this.validateKey(this.keys.getPrevious(), "previous", false);
        } else {
            Date pendingKeyCreationTime;
            Mediator mediator = MgmtFactory.getMediator();
            Date date = pendingKeyCreationTime = this.keys.getPending() == null ? null : this.keys.getPending().getCreationDate();
            if (!mediator.isStandalone()) {
                Date configPublishDate = mediator.getConfigPublishDate();
                if (pendingKeyCreationTime == null || configPublishDate == null) {
                    return true;
                }
                if (pendingKeyCreationTime.after(configPublishDate)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.system_keys_cluster_replication_required, null));
                }
            }
        }
        return !this.hasErrors();
    }

    private void validateKey(SystemKey systemKey, String keyType, boolean keyRequired) {
        if (keyRequired && systemKey == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.system_keys_key_required, keyType, new Object[]{StringUtils.capitalize((String)keyType)}));
        } else if (systemKey != null && StringUtils.isBlank((String)systemKey.getEncryptedKeyData()) && StringUtils.isBlank((String)systemKey.getKeyData())) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.system_keys_key_material_required, keyType, new Object[]{keyType}));
        } else if (systemKey != null && StringUtils.isNotBlank((String)systemKey.getEncryptedKeyData()) && StringUtils.isNotBlank((String)systemKey.getKeyData())) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.system_keys_both_encrypted_and_clear_key_data_provided, keyType, new Object[]{keyType}));
        } else if (systemKey != null && StringUtils.isNotBlank((String)systemKey.getEncryptedKeyData()) && Obfuscator.deobfuscateBinary((String)systemKey.getEncryptedKeyData()) == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.system_keys_could_not_deobfuscate_encrypted_key_data, keyType + ".encryptedKeyData", new Object[]{keyType}));
        } else if (systemKey != null && StringUtils.isNotBlank((String)systemKey.getEncryptedKeyData()) && Obfuscator.deobfuscateBinary((String)systemKey.getEncryptedKeyData()).length != 32) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.system_keys_key_length, keyType + ".encryptedKeyData", new Object[]{32}));
        } else if (systemKey != null && StringUtils.isNotBlank((String)systemKey.getKeyData())) {
            if (!B64.isBase64((String)systemKey.getKeyData())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.system_keys_invalid_key_format, keyType + ".keyData"));
            } else if (B64.decodeToBytes((String)systemKey.getKeyData()).length != 32) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.system_keys_key_length, keyType + ".keyData", new Object[]{32}));
            }
        }
    }
}

