/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.util.Substituter;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class TextSourceTypeValidator
extends AbstractValidator {
    private final String attributeName;
    private final String value;
    private final boolean isAcceptAnyValue;
    private final boolean isAcceptBlankValues;
    private final Set<String> validSubstitutionVars;
    private final String fieldPath;

    TextSourceTypeValidator() {
        this.attributeName = null;
        this.value = null;
        this.isAcceptAnyValue = true;
        this.isAcceptBlankValues = true;
        this.validSubstitutionVars = Collections.emptySet();
        this.fieldPath = null;
    }

    TextSourceTypeValidator(String attributeName, String value, boolean isAcceptBlankValues, Set<String> validSubstitutionVars, String fieldPath) {
        this.attributeName = attributeName;
        this.value = value;
        this.isAcceptAnyValue = false;
        this.isAcceptBlankValues = isAcceptBlankValues;
        this.validSubstitutionVars = validSubstitutionVars != null ? validSubstitutionVars : Collections.emptySet();
        this.fieldPath = fieldPath;
    }

    public boolean validate() {
        if (this.isAcceptAnyValue) {
            return true;
        }
        if (!this.isAcceptBlankValues && StringUtils.isBlank((String)this.value)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.mapping_source_type_text_value_blank, this.fieldPath, new Object[]{this.attributeName}));
        }
        if (!Substituter.checkSubstituteValues((String)this.value, this.validSubstitutionVars)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.mapping_source_type_text_invalid_substitution_variable, this.fieldPath, new Object[]{this.attributeName}));
        }
        return !this.hasErrors();
    }
}

