/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.ConditionalIssuanceCriteriaEntry;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.TextSourceTypeValidator;
import com.pingidentity.pf.common.api.validator.Validator;
import java.util.Set;

public class TextSourceTypeValidatorBuilder
extends SourceTypeValidatorBuilder {
    private boolean isAcceptAnyValue;
    private boolean isAcceptBlankValues;

    @Override
    public Validator buildMappingValidator(String attributeName, AttributeFulfillmentValue afv, String attributePath) {
        this.checkAndThrowForIllegalSourceType(afv.getSource().getType(), SourceType.TEXT);
        if (this.isAcceptAnyValue) {
            return new TextSourceTypeValidator();
        }
        return new TextSourceTypeValidator(attributeName, afv.getValue(), this.isAcceptBlankValues, this.getSubstitutionVariables(), attributePath);
    }

    public Validator buildMappingValidator(String expression) {
        return new TextSourceTypeValidator("", expression, this.isAcceptBlankValues, this.getSubstitutionVariables(), "");
    }

    @Override
    public Validator buildConditionalIssuanceCriteriaValidator(ConditionalIssuanceCriteriaEntry icEntry, String attributePath) {
        throw new UnsupportedOperationException();
    }

    public boolean isAcceptAnyValue() {
        return this.isAcceptAnyValue;
    }

    public void setAcceptAnyValue(boolean isAcceptAnyValue) {
        this.isAcceptAnyValue = isAcceptAnyValue;
    }

    public boolean isAcceptBlankValues() {
        return this.isAcceptBlankValues;
    }

    public void setAcceptBlankValues(boolean isAcceptBlankValues) {
        this.isAcceptBlankValues = isAcceptBlankValues;
    }

    @Override
    public Set<String> getExposedSubstitutionVariables() {
        return null;
    }

    @Override
    public boolean acceptsSubstitutionVariables() {
        return true;
    }
}

