/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.PluginInstancePaths;
import com.pingidentity.admin.api.model.plugin.TokenGenerator;
import com.pingidentity.admin.api.model.plugin.TokenGeneratorAttribute;
import com.pingidentity.admin.api.translator.plugin.PluginEnum;
import com.pingidentity.admin.api.validator.AttributeContractValidator;
import com.pingidentity.admin.api.validator.PluginInstanceValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import com.pingidentity.sdk.PluginDescriptor;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class TokenGeneratorValidator
extends PluginInstanceValidator {
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private final TokenGenerator instance;

    public TokenGeneratorValidator(TokenGenerator apiInstance, ValidatorContext validatorContext) {
        super(apiInstance, PluginEnum.TOKEN_GENERATOR.getPluginManager(), !validatorContext.isUpdateRequest(), PluginEnum.TOKEN_GENERATOR, validatorContext);
        this.instance = apiInstance;
    }

    @Override
    public boolean validate() {
        boolean doContractValidation;
        super.validate();
        boolean askedForParent = this.instance.getParentRef() != null;
        boolean isInherited = this.getBooleanVal(this.instance.getAttributeContract().isInherited());
        boolean bl = doContractValidation = !isInherited || !askedForParent;
        if (isInherited && !askedForParent) {
            this.appendError(this.errorFactory.create(ApiMessageKey.plugin_attribute_contract_parent_not_defined, PluginInstancePaths.AttributeContractPaths.getContractInherited()));
        }
        if (doContractValidation) {
            boolean pluginAllowsExtAttrs = true;
            Set coreAttrs = new HashSet();
            LinkedList<TokenGeneratorAttribute> attributes = new LinkedList<TokenGeneratorAttribute>();
            String pluginTypeId = null;
            if (this.instance.getPluginDescriptorRef() != null) {
                pluginTypeId = this.instance.getPluginDescriptorRef().getId();
            }
            if (pluginTypeId != null) {
                for (PluginDescriptor pluginDescriptor : PluginEnum.TOKEN_GENERATOR.getPluginManager().getInstalledDescriptors()) {
                    if (!pluginDescriptor.getPluginClassName().equals(pluginTypeId)) continue;
                    Set descriptorAttrs = pluginDescriptor.getAttributeContractSet();
                    if (descriptorAttrs != null) {
                        coreAttrs = descriptorAttrs;
                    }
                    pluginAllowsExtAttrs = pluginDescriptor.isSupportsExtendedContract();
                    break;
                }
            }
            int i = 0;
            for (TokenGeneratorAttribute coreAttr : this.instance.getAttributeContract().getCoreAttributes()) {
                attributes.add(coreAttr);
                if (StringUtils.isNotBlank((String)coreAttr.getName()) && !coreAttrs.contains(coreAttr.getName())) {
                    this.appendError(this.errorFactory.create(ApiMessageKey.attribute_contract_unknown_core_attribute, PluginInstancePaths.AttributeContractPaths.getCoreContractAttribute(i), new Object[]{coreAttr.getName()}));
                }
                ++i;
            }
            List<TokenGeneratorAttribute> extendedAttrs = this.instance.getAttributeContract().getExtendedAttributes();
            if (!pluginAllowsExtAttrs && extendedAttrs != null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.plugin_descriptor_ext_attrs_not_supported, PluginInstancePaths.AttributeContractPaths.getExtendedContractAttributes()));
            }
            AttributeContractValidator<TokenGeneratorAttribute> attributeContractValidator = new AttributeContractValidator<TokenGeneratorAttribute>(attributes, extendedAttrs, PluginInstancePaths.AttributeContractPaths.getAttributeContract());
            attributeContractValidator.validate();
            this.appendErrors(attributeContractValidator.getErrors());
        }
        return !this.hasErrors();
    }
}

