/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class TokenSourceTypeValidator
extends AbstractValidator {
    private final String attributeName;
    private final String value;
    private final String fieldPath;
    private final Set<String> validAttrNames;
    private final TokenSourceTypeMsgContext msgContext;

    TokenSourceTypeValidator(String attributeName, String value, Set<String> validAttrNames, String fieldPath, TokenSourceTypeMsgContext msgContext) {
        this.attributeName = attributeName;
        this.value = value;
        this.validAttrNames = validAttrNames;
        this.fieldPath = fieldPath;
        this.msgContext = msgContext;
    }

    public boolean validate() {
        if (StringUtils.isBlank((String)this.value)) {
            this.appendError(ValidationErrorFactory.getInstance().create(this.msgContext.getUnknownValueKey(), this.fieldPath, new Object[]{this.value, this.attributeName}));
        } else if (!this.validAttrNames.contains(this.value)) {
            this.appendError(ValidationErrorFactory.getInstance().create(this.msgContext.getValueNotApplicableKey(), this.fieldPath, new Object[]{this.value, this.attributeName}));
        }
        return !this.hasErrors();
    }

    public static enum TokenSourceTypeMsgContext {
        ATTR_MAPPING{

            @Override
            public ApiMessageKey getUnknownValueKey() {
                return ApiMessageKey.mapping_source_type_token_unknown_value;
            }

            @Override
            public ApiMessageKey getValueNotApplicableKey() {
                return ApiMessageKey.mapping_source_type_token_value_not_applicable;
            }
        }
        ,
        ISSUANCE_CRITERIA{

            @Override
            public ApiMessageKey getUnknownValueKey() {
                return ApiMessageKey.issuance_criteria_source_type_token_unknown_value;
            }

            @Override
            public ApiMessageKey getValueNotApplicableKey() {
                return ApiMessageKey.issuance_criteria_source_type_token_value_not_applicable;
            }
        };


        public abstract ApiMessageKey getUnknownValueKey();

        public abstract ApiMessageKey getValueNotApplicableKey();
    }
}

