/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.ConditionalIssuanceCriteriaEntry;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.validator.ConditionalIssuanceCriteriaEntryValidator;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.TokenSourceTypeValidator;
import com.pingidentity.pf.common.api.validator.Validator;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class TokenSourceTypeValidatorBuilder
extends SourceTypeValidatorBuilder {
    private final Set<String> tokenAttributes;
    private final String prefix;
    private SourceType expectedSourceType = SourceType.TOKEN;

    public TokenSourceTypeValidatorBuilder(Set<String> tokenAttributes) {
        this.tokenAttributes = tokenAttributes;
        this.prefix = null;
    }

    public TokenSourceTypeValidatorBuilder(Set<String> tokenAttributes, String prefix) {
        this.tokenAttributes = tokenAttributes;
        this.prefix = prefix;
    }

    public TokenSourceTypeValidatorBuilder setExpectedSourceType(SourceType expectedSourceType) {
        this.expectedSourceType = expectedSourceType;
        return this;
    }

    @Override
    public Validator buildMappingValidator(String attributeName, AttributeFulfillmentValue afv, String attributePath) {
        this.checkAndThrowForIllegalSourceType(afv.getSource().getType(), this.expectedSourceType);
        return new TokenSourceTypeValidator(attributeName, afv.getValue(), this.tokenAttributes, attributePath, TokenSourceTypeValidator.TokenSourceTypeMsgContext.ATTR_MAPPING);
    }

    @Override
    public Validator buildConditionalIssuanceCriteriaValidator(ConditionalIssuanceCriteriaEntry icEntry, String attributePath) {
        this.checkAndThrowForIllegalSourceType(icEntry.getSource().getType(), this.expectedSourceType);
        return new ConditionalIssuanceCriteriaEntryValidator((Validator)new TokenSourceTypeValidator(null, icEntry.getAttributeName(), this.tokenAttributes, attributePath, TokenSourceTypeValidator.TokenSourceTypeMsgContext.ISSUANCE_CRITERIA), icEntry, attributePath);
    }

    @Override
    public Set<String> getExposedSubstitutionVariables() {
        return StringUtils.isBlank((String)this.prefix) ? Collections.unmodifiableSet(this.tokenAttributes) : this.tokenAttributes.stream().map(s -> this.prefix + s).collect(Collectors.toSet());
    }

    @Override
    public boolean acceptsSubstitutionVariables() {
        return false;
    }
}

