/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.ConditionalIssuanceCriteriaEntry;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.validator.ConditionalIssuanceCriteriaEntryValidator;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.Validator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class TrackedParametersSourceTypeValidatorBuilder
extends SourceTypeValidatorBuilder {
    private final List<String> trackedParams;
    private final SourceType sourceType = SourceType.TRACKED_HTTP_PARAMS;

    public TrackedParametersSourceTypeValidatorBuilder(List<String> trackedParams) {
        this.trackedParams = trackedParams;
    }

    @Override
    public Validator buildMappingValidator(String attributeName, AttributeFulfillmentValue afv, String attributePath) {
        this.checkAndThrowForIllegalSourceType(afv.getSource().getType(), this.sourceType);
        return new TrackedParamsSourceTypeValidator(this.trackedParams, afv.getValue(), attributePath);
    }

    @Override
    public Validator buildConditionalIssuanceCriteriaValidator(ConditionalIssuanceCriteriaEntry icEntry, String attributePath) {
        this.checkAndThrowForIllegalSourceType(icEntry.getSource().getType(), this.sourceType);
        TrackedParamsSourceTypeValidator validator = new TrackedParamsSourceTypeValidator(this.trackedParams, icEntry.getAttributeName(), attributePath);
        return new ConditionalIssuanceCriteriaEntryValidator((Validator)validator, icEntry, attributePath);
    }

    @Override
    public Set<String> getExposedSubstitutionVariables() {
        return this.trackedParams.stream().map(param -> "trackedparams." + param).collect(Collectors.toSet());
    }

    @Override
    public boolean acceptsSubstitutionVariables() {
        return false;
    }

    private static class TrackedParamsSourceTypeValidator
    extends AbstractValidator {
        private final List<String> trackedParams;
        private final String valueToLookFor;
        private final String fieldPath;

        public TrackedParamsSourceTypeValidator(List<String> trackedParams, String valueToLookFor, String fieldPath) {
            this.trackedParams = trackedParams;
            this.valueToLookFor = valueToLookFor;
            this.fieldPath = fieldPath;
        }

        public boolean validate() {
            if (this.trackedParams == null || !this.trackedParams.contains(this.valueToLookFor)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.source_type_invalid_tracked_http_params, this.fieldPath, new Object[]{this.valueToLookFor}));
            }
            return !this.hasErrors();
        }
    }
}

