/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.HashSet;
import java.util.List;

public class UniqueEntriesValidator<E>
extends AbstractValidator {
    private boolean ignoreNullEntries = false;
    private final UniqueKeyGetter<E> keyGetter;
    private final List<E> entries;
    private final ApiMessageKey duplicateErrorKey;
    private final boolean allowEmptyEntries;
    private final ApiMessageKey emptyErrorKey;
    private final String collectionFieldPath;

    public UniqueEntriesValidator(UniqueKeyGetter<E> keyGetter, List<E> entries, String collectionFieldPath, ApiMessageKey duplicateErrorKey) {
        this.keyGetter = keyGetter;
        this.entries = entries;
        this.duplicateErrorKey = duplicateErrorKey;
        this.collectionFieldPath = collectionFieldPath;
        this.emptyErrorKey = null;
        this.allowEmptyEntries = true;
    }

    public UniqueEntriesValidator(UniqueKeyGetter<E> keyGetter, List<E> entries, String collectionFieldPath, ApiMessageKey duplicateErrorKey, ApiMessageKey emptyErrorKey) {
        this.keyGetter = keyGetter;
        this.entries = entries;
        this.duplicateErrorKey = duplicateErrorKey;
        this.collectionFieldPath = collectionFieldPath;
        this.emptyErrorKey = emptyErrorKey;
        this.allowEmptyEntries = false;
    }

    public boolean validate() {
        if (!this.allowEmptyEntries && this.entries.isEmpty()) {
            this.appendError(ValidationErrorFactory.getInstance().create(this.emptyErrorKey, this.collectionFieldPath));
        }
        HashSet<String> foundKeys = new HashSet<String>();
        HashSet<String> duplicateKeys = new HashSet<String>();
        boolean seenNullEntryError = false;
        for (E entry : this.entries) {
            if (entry == null && !this.ignoreNullEntries && !seenNullEntryError) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.list_cannot_contain_empty_entries, this.collectionFieldPath));
                seenNullEntryError = true;
                continue;
            }
            String key = this.keyGetter.getKey(entry);
            if (key == null) continue;
            if (foundKeys.contains(key)) {
                if (!duplicateKeys.contains(key)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(this.duplicateErrorKey, this.collectionFieldPath, new Object[]{key}));
                }
                duplicateKeys.add(key);
            }
            foundKeys.add(key);
        }
        return !this.hasErrors();
    }

    public void setIgnoreNullEntries(boolean ignoreNullEntries) {
        this.ignoreNullEntries = ignoreNullEntries;
    }

    public static abstract class UniqueKeyGetter<F> {
        public abstract String getKey(F var1);
    }
}

