/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.fieldpaths.PluginInstancePaths;
import com.pingidentity.admin.api.model.plugin.ConfigField;
import com.pingidentity.admin.api.model.plugin.IdpAdapterAttribute;
import com.pingidentity.admin.api.model.plugin.PluginConfiguration;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

public class UniqueUserKeyAttributeValidator
extends AbstractValidator {
    static final String HTML_FORM_IDP_AUTHN_ADAPTER = "HtmlFormIdpAuthnAdapter";
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private final List<IdpAdapterAttribute> coreAttributes;
    private final List<IdpAdapterAttribute> extendedAttributes;
    private final String uniqueUserKeyAttribute;
    private final String parentPath;
    private final ResourceLink adapterResourceLink;
    private final PluginConfiguration adapterConfig;

    public UniqueUserKeyAttributeValidator(String uniqueUserKeyAttribute, List<IdpAdapterAttribute> coreAttributes, List<IdpAdapterAttribute> extendedAttributes, String parentPath, ResourceLink adapterResourceLink, PluginConfiguration adapterConfig) {
        this.uniqueUserKeyAttribute = uniqueUserKeyAttribute;
        this.coreAttributes = coreAttributes;
        this.extendedAttributes = extendedAttributes;
        this.parentPath = parentPath;
        this.adapterResourceLink = adapterResourceLink;
        this.adapterConfig = adapterConfig;
    }

    public boolean validate() {
        List fields;
        String revokeSessions;
        if (StringUtils.isNotEmpty((String)this.uniqueUserKeyAttribute)) {
            HashSet completeAttributeSet = new HashSet();
            if (this.coreAttributes != null) {
                this.coreAttributes.forEach(idpAdapterAttribute -> completeAttributeSet.add(idpAdapterAttribute.getName()));
            }
            if (this.extendedAttributes != null) {
                this.extendedAttributes.forEach(idpAdapterAttribute -> completeAttributeSet.add(idpAdapterAttribute.getName()));
            }
            if (!completeAttributeSet.contains(this.uniqueUserKeyAttribute)) {
                this.appendError(this.errorFactory.create(ApiMessageKey.idp_adapter_specified_attribute_does_not_exist, this.appendFieldPath(this.parentPath, PluginInstancePaths.AttributeContractPaths.getUniqueUserKeyAttribute()), new Object[]{this.uniqueUserKeyAttribute}));
            }
        } else if (this.adapterResourceLink != null && StringUtils.containsIgnoreCase((String)this.adapterResourceLink.getId(), (String)HTML_FORM_IDP_AUTHN_ADAPTER) && (revokeSessions = (String)(fields = Optional.ofNullable(this.adapterConfig).map(PluginConfiguration::getFields).orElse(Collections.emptyList())).stream().filter(configField -> "Revoke Sessions After Password Change Or Reset".equals(configField.getName())).findFirst().map(ConfigField::getValue).orElse(null)) != null && StringUtils.equalsIgnoreCase((String)revokeSessions, (String)"true")) {
            this.appendError(this.errorFactory.create(ApiMessageKey.idp_adapter_html_form_idp_adapter_revoke_sessions_enabled_needs_unique_user_key, this.appendFieldPath(this.parentPath, PluginInstancePaths.AttributeContractPaths.getUniqueUserKeyAttribute()), new Object[]{"Revoke Sessions After Password Change Or Reset"}));
        }
        return this.hasErrors();
    }
}

