/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.ConnectionType;
import com.pingidentity.admin.api.model.UrlWhitelistEntry;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.List;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.mgmt.TargetResourceValidationMgr;

public class UrlWhiteListValidator
extends AbstractValidator {
    private final List<UrlWhitelistEntry> entryList;
    private static TargetResourceValidationMgr targetResourceValidationMgr = (TargetResourceValidationMgr)GlobalRegistry.getService(TargetResourceValidationMgr.class);
    private final ConnectionType type;

    public UrlWhiteListValidator(List<UrlWhitelistEntry> entryList, ConnectionType type) {
        this.entryList = entryList;
        this.type = type;
    }

    public boolean validate() {
        boolean valid = true;
        int index = 0;
        if (this.entryList != null) {
            for (UrlWhitelistEntry entry : this.entryList) {
                List domainErrors = targetResourceValidationMgr.validateDomain(entry.getValidDomain());
                List pathErrors = targetResourceValidationMgr.validatePath(entry.getValidPath(), entry.isAllowQueryAndFragment());
                if (domainErrors != null && domainErrors.size() > 0) {
                    for (String domainError : domainErrors) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.whitelist_url_entry_invalid.getMsgKey(), domainError, ConnectionPaths.getUrlWhiteListEntries(this.type.getRole(), index)));
                    }
                    valid = false;
                }
                if (pathErrors != null && pathErrors.size() > 0) {
                    for (String pathError : pathErrors) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.whitelist_url_entry_invalid.getMsgKey(), pathError, ConnectionPaths.getUrlWhiteListEntries(this.type.getRole(), index)));
                    }
                    valid = false;
                }
                ++index;
            }
        }
        return valid;
    }
}

